/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.eai;

import com.digiwin.app.eai.DWEAI;
import com.digiwin.app.eai.DigiHost;
import com.digiwin.app.eai.DigiProtocol;
import com.digiwin.app.eai.DigiService;
import com.digiwin.app.eai.DigiType;
import com.digiwin.app.service.DWServiceContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class DWEAIBuilder {
    private DigiHost digiHost;
    private DigiService digiService;
    private Map<String, Object> parameter;
    private Map<String, String> customHeader;
    private Map<String, String> customCallbackHeader;
    private DigiType digiType = DigiType.sync;
    private DigiProtocol digiProtocol = DigiProtocol.raw;
    private String digiDatakey;
    private String callback;

    public DWEAIBuilder(String prod, String name, Map<String, Object> parameter) {
        this.digiHost = new DigiHost();
        this.digiService = new DigiService(prod, name);
        this.parameter = parameter;
        this.customHeader = new HashMap<String, String>();
        this.customCallbackHeader = new HashMap<String, String>();
    }

    public DWEAIBuilder(String site_id, String prod, String name, Map<String, Object> parameter) {
        this.digiHost = new DigiHost();
        this.digiService = new DigiService(prod, name);
        this.parameter = parameter;
        Map profile = DWServiceContext.getContext().getProfile();
        Optional<Object> profileOptional = profile == null ? Optional.empty() : Optional.of(profile);
        String tenant_id = String.valueOf(((Map)profileOptional.orElse(new HashMap())).getOrDefault("tenantId", ""));
        this.digiService.setTenantId(tenant_id);
        this.digiService.setSiteId(site_id);
    }

    public DWEAIBuilder sync() {
        this.digiType = DigiType.sync;
        return this;
    }

    public DWEAIBuilder async(String callback) {
        this.digiType = DigiType.async;
        this.callback = callback;
        return this;
    }

    public DWEAIBuilder setDigiProtocol(DigiProtocol digiProtocol) {
        this.digiProtocol = digiProtocol;
        return this;
    }

    public DigiProtocol getDigiProtocol() {
        return this.digiProtocol;
    }

    public DWEAIBuilder setDigiHostLang(DigiHost.lang lang2) {
        this.digiHost.setLang(lang2);
        return this;
    }

    public DWEAIBuilder setDigiHostAcct(String acct) {
        this.digiHost.setAcct(acct);
        return this;
    }

    public DWEAIBuilder setDigiServiceSrvver(String srvver) {
        this.digiService.setSrvver(srvver);
        return this;
    }

    public DWEAIBuilder setDigiServiceIp(String ip) {
        this.digiService.setIp(ip);
        return this;
    }

    public DWEAIBuilder setDigiServiceId(String id) {
        this.digiService.setId(id);
        return this;
    }

    public DWEAIBuilder setDigiServiceUid(String uid) {
        this.digiService.setUid(uid);
        return this;
    }

    public DWEAIBuilder setDigiDatakey(String digiDatakey) {
        this.digiDatakey = digiDatakey;
        return this;
    }

    public String getDigiDatakey() {
        return this.digiDatakey;
    }

    public DWEAIBuilder setCustomHeader(Map<String, String> customHeader) {
        this.customHeader = customHeader;
        return this;
    }

    public DWEAIBuilder setCustomCallbackHeader(Map<String, String> customCallbackHeader) {
        this.customCallbackHeader = customCallbackHeader;
        return this;
    }

    public DWEAI build() {
        DWEAI dwEAI = new DWEAI(this.digiType, this.digiProtocol, this.digiHost, this.digiService, this.parameter);
        dwEAI.setDigiDatakey(this.digiDatakey);
        dwEAI.setCallback(this.callback);
        dwEAI.setCustomHeader(this.customHeader);
        dwEAI.setCustomCallbackHeader(this.customCallbackHeader);
        return dwEAI;
    }

    public DigiHost getDigiHost() {
        return this.digiHost;
    }

    public DigiService getDigiService() {
        return this.digiService;
    }

    public DigiType getDigiType() {
        return this.digiType;
    }

    public Object getCustomHeader() {
        return this.customHeader;
    }

    public Map<String, String> getCustomCallbackHeader() {
        return this.customCallbackHeader;
    }
}

