/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.eai;

import com.digiwin.app.common.DWApplicationSpringUtils;
import com.digiwin.app.eai.DWEAIFuse;
import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.app.eai.DigiHost;
import com.digiwin.app.eai.DigiProtocol;
import com.digiwin.app.eai.DigiService;
import com.digiwin.app.eai.DigiType;
import com.digiwin.app.eai.util.MD5;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.gateway.fuse.DWFuseExecutor;
import com.digiwin.gateway.fuse.DWReturnFuse;
import com.digiwin.gateway.fuse.config.OutboundConfig;
import com.digiwin.gateway.fuse.execute.DWFuseOption;
import com.digiwin.gateway.fuse.execute.DWFuseParameter;
import com.digiwin.gateway.fuse.execute.DWFuseReturnResponse;
import io.prometheus.client.CollectorRegistry;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.json.JSONObject;
import org.springframework.context.ApplicationContext;

public class DWEAI {
    private static Log log = LogFactory.getLog(DWEAI.class);
    private static final String CONTENT_TYPE = "application/json; charset=utf-8";
    private DigiType digiType;
    private DigiProtocol digiProtocol;
    private DigiHost digiHost;
    private DigiService digiService;
    private Map<String, Object> parameter;
    private String digiDatakey;
    private String callback;
    private Map<String, String> customHeader;
    private Map<String, String> customCallbackHeader;

    public DWEAI(DigiType digiType, DigiProtocol digiProtocol, DigiHost digiHost, DigiService digiService, Map<String, Object> parameter) {
        this.digiType = digiType;
        this.digiProtocol = digiProtocol;
        this.digiHost = digiHost;
        this.digiService = digiService;
        this.parameter = parameter;
        this.customHeader = new HashMap<String, String>();
        this.customCallbackHeader = new HashMap<String, String>();
    }

    public Map<String, Object> execute() throws Exception {
        if (this.digiProtocol.equals((Object)DigiProtocol.ftp) && !this.digiType.equals((Object)DigiType.async)) {
            throw new IllegalStateException("DigiProtocol = ftp, DigiType must be async!!");
        }
        if (this.digiProtocol.equals((Object)DigiProtocol.serial)) {
            if (!this.parameter.containsKey("zip_data")) {
                throw new IllegalStateException("parameter must contain key - zip_data");
            }
            if (!this.parameter.containsKey("file_name")) {
                throw new IllegalStateException("parameter must contain key - file_name");
            }
        }
        if (this.digiProtocol.equals((Object)DigiProtocol.ftp)) {
            if (!this.parameter.containsKey("zip_path")) {
                throw new IllegalStateException("parameter must contain key - zip_path");
            }
            if (!this.parameter.containsKey("file_name")) {
                throw new IllegalStateException("parameter must contain key - file_name");
            }
        }
        HttpPost httpPost = this.getHttpPost();
        Map<String, Object> result = this.executeHttpRequest(httpPost);
        return result;
    }

    private HttpPost getHttpPost() throws Exception {
        String value;
        String key;
        String url = DWEAIProperties.getProperties().getServerUrl();
        HttpPost httpPost = new HttpPost(url + "/CROSS/RESTful");
        httpPost.addHeader("Content-Type", CONTENT_TYPE);
        httpPost.addHeader("digi-type", this.digiType.value());
        httpPost.addHeader("digi-protocol", this.digiProtocol.value());
        String digiHostJson = this.digiHost.toJSON();
        httpPost.addHeader("digi-host", this.digiHost.toJSON());
        String digiServiceJson = this.digiService.toJSON();
        httpPost.addHeader("digi-service", digiServiceJson);
        String token = DWServiceContext.getContext().getToken();
        if (!StringUtils.isBlank((CharSequence)token)) {
            httpPost.addHeader("digi-token", token);
        }
        String digiKey = MD5.generate(digiHostJson + digiServiceJson).toUpperCase();
        httpPost.addHeader("digi-key", digiKey);
        if (!StringUtils.isBlank((CharSequence)this.digiDatakey)) {
            httpPost.addHeader("digi-datakey", this.digiDatakey);
        }
        if (DigiType.async.equals((Object)this.digiType) || DigiType.fasync.equals((Object)this.digiType)) {
            if (StringUtils.isBlank((CharSequence)token)) {
                token = "";
            }
            httpPost.addHeader("digi-callback-token", token);
            httpPost.addHeader("digi-callback-callback", this.callback);
        }
        for (Map.Entry<String, String> entry : this.customHeader.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (key.startsWith("digi-")) {
                httpPost.addHeader(key, value);
                continue;
            }
            if ("routerKey".equals(key)) {
                httpPost.addHeader(key, value);
                continue;
            }
            httpPost.addHeader("digi-" + key, value);
        }
        for (Map.Entry<String, String> entry : this.customCallbackHeader.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (key.startsWith("digi-callback-")) {
                httpPost.addHeader(key, value);
                continue;
            }
            httpPost.addHeader("digi-callback-" + key, value);
        }
        String digiReqid = DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-reqid", "");
        String callbackParentDigiReqid = DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-callback-parent-reqid", digiReqid);
        httpPost.addHeader("digi-callback-parent-reqid", callbackParentDigiReqid);
        StringEntity stringEntity = new StringEntity("", StandardCharsets.UTF_8);
        switch (this.digiProtocol) {
            case raw: {
                HashMap<String, Map<String, Object>> parameterJo = new HashMap<String, Map<String, Object>>();
                parameterJo.put("parameter", this.parameter);
                HashMap<String, HashMap<String, Map<String, Object>>> stdDataJo = new HashMap<String, HashMap<String, Map<String, Object>>>();
                stdDataJo.put("std_data", parameterJo);
                String stdDataJoJson = DWGsonProvider.getGson().toJson(stdDataJo);
                stringEntity = new StringEntity(stdDataJoJson, StandardCharsets.UTF_8);
                break;
            }
            case serial: {
                String serialBody = DWGsonProvider.getGson().toJson(this.parameter);
                stringEntity = new StringEntity(serialBody, StandardCharsets.UTF_8);
                break;
            }
            case ftp: {
                String ftpBody = DWGsonProvider.getGson().toJson(this.parameter);
                stringEntity = new StringEntity(ftpBody, StandardCharsets.UTF_8);
            }
        }
        httpPost.setEntity((HttpEntity)stringEntity);
        return httpPost;
    }

    private Map<String, Object> executeHttpRequest(HttpPost httpPost) throws Exception {
        OutboundConfig outboundConfig = this.getOutboundConfig();
        CollectorRegistry collectorRegistry = null;
        try {
            ApplicationContext applicationContext = DWApplicationSpringUtils.getContext();
            collectorRegistry = (CollectorRegistry)applicationContext.getBean(CollectorRegistry.class);
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            String stackTrace = stringWriter.toString();
            log.debug((Object)("[DWEAI] collectorRegistry: " + e.getMessage()));
            log.debug((Object)("[DWEAI] collectorRegistry: " + stackTrace));
        }
        outboundConfig.setCollectorRegistry(collectorRegistry);
        DWEAIFuse eaiFuse = new DWEAIFuse();
        DWFuseParameter fuseParameter = new DWFuseParameter();
        fuseParameter.set("httpPost", (Object)httpPost);
        DWFuseReturnResponse response = new DWFuseReturnResponse((Object)new JSONObject());
        DWFuseOption option = DWFuseOption.getDefaultOption();
        option.setAutoFuseHttpStatusCode(false);
        log.debug((Object)("[DWEAI] option: " + option));
        response = DWFuseExecutor.execute((DWReturnFuse)eaiFuse, (DWFuseParameter)fuseParameter, (OutboundConfig)outboundConfig, (DWFuseOption)option);
        JSONObject responseJo = (JSONObject)response.getResponse();
        return responseJo.toMap();
    }

    public void setDigiDatakey(String digiDatakey) {
        this.digiDatakey = digiDatakey;
    }

    public void setCallback(String callback) {
        this.callback = callback;
    }

    public void setCustomHeader(Map<String, String> customHeader) {
        this.customHeader = customHeader;
    }

    public void setCustomCallbackHeader(Map<String, String> customCallbackHeader) {
        this.customCallbackHeader = customCallbackHeader;
    }

    public DigiService getDigiService() {
        return this.digiService;
    }

    public DigiHost getDigiHost() {
        return this.digiHost;
    }

    public String getDigiDatakey() {
        return this.digiDatakey;
    }

    public Map<String, String> getCustomHeader() {
        return this.customHeader;
    }

    public Map<String, String> getCustomCallbackHeader() {
        return this.customCallbackHeader;
    }

    public String getCallback() {
        return this.callback;
    }

    private OutboundConfig getOutboundConfig() {
        String key = "eai";
        return OutboundConfig.create((String)key);
    }
}

