/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log;

import com.digiwin.app.log.CompressUtil;
import com.digiwin.app.log.JsonUtil;
import com.digiwin.app.log.dto.DapLogDto;
import com.digiwin.app.log.dto.DapRequest;
import com.digiwin.app.log.dto.DapService;
import com.digiwin.app.log.dto.LogItem;
import com.digiwin.app.service.DWEAIChainEndResult;
import com.digiwin.app.service.DWEAIChainProgressResult;
import com.digiwin.app.service.DWEAIFasyncChainEndResult;
import com.digiwin.app.service.DWEAIResult;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DapLogUtils {
    public static DapLogDto getDapCallbackLog(Object invokeResult, Map<String, Object> requestHeader) {
        DapLogDto dapLogDto = new DapLogDto();
        String logUrl = requestHeader.getOrDefault("digi-callback-logurl", "").toString();
        dapLogDto.setReq_id(requestHeader.getOrDefault("digi-reqid", UUID.randomUUID().toString()).toString());
        dapLogDto.setLogUrl(logUrl);
        Map<String, Object> digiserviceMap = JsonUtil.fromJsonMap(requestHeader.getOrDefault("digi-service", "").toString());
        Map<String, Object> digihostMap = JsonUtil.fromJsonMap(requestHeader.getOrDefault("digi-host", "").toString());
        String targetUrl = requestHeader.getOrDefault("digi-callback-url", "").toString();
        DapRequest request = new DapRequest();
        request.setAp_name(DapLogUtils.getSafeMapKey(digihostMap, "prod"));
        request.setVersion(DapLogUtils.getSafeMapKey(digihostMap, "ver"));
        request.setId("");
        request.setUid("");
        request.setAp_user(DapLogUtils.getSafeMapKey(digihostMap, "tenant_id"));
        request.setTimestamp(String.valueOf(System.currentTimeMillis()));
        dapLogDto.setRequest(request);
        DapService service = new DapService();
        service.setAp_name(DapLogUtils.getSafeMapKey(digiserviceMap, "prod"));
        service.setVersion("");
        service.setIp(requestHeader.getOrDefault("host", "").toString());
        service.setUid("");
        service.setId("");
        service.setTenant_id(DapLogUtils.getSafeMapKey(digiserviceMap, "tenant_id"));
        service.setService_name(requestHeader.getOrDefault("digi-callback-callback", "").toString());
        dapLogDto.setService(service);
        LogItem logItem = new LogItem();
        String stateCode = null;
        String priority = null;
        if (invokeResult != null && invokeResult.getClass().equals(DWEAIResult.class)) {
            stateCode = "0ED";
            priority = "3";
        } else if (invokeResult != null && invokeResult.getClass().equals(DWEAIChainProgressResult.class)) {
            stateCode = "0EA";
            priority = "4";
        } else if (invokeResult != null && invokeResult.getClass().equals(DWEAIFasyncChainEndResult.class)) {
            stateCode = "0EA";
            priority = "5";
        } else if (invokeResult != null && invokeResult.getClass().equals(DWEAIChainEndResult.class)) {
            stateCode = "0ED";
            priority = "3";
        } else if (invokeResult instanceof Map) {
            stateCode = "0ED";
            priority = "3";
        }
        if (StringUtils.isNotBlank((CharSequence)stateCode)) {
            logItem = DapLogUtils.createLogItem(stateCode, priority, targetUrl, requestHeader.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                if (null == entry.getValue()) {
                    return "";
                }
                return entry.getValue().toString();
            }, (o1, o2) -> o2)), JsonUtil.toString(((DWEAIResult)invokeResult).getDWEAIResult()));
        }
        dapLogDto.setLogs(new LogItem[]{logItem});
        return dapLogDto;
    }

    public static LogItem createLogItem(String stateCode, String priority, String targetUrl, Map<String, String> headers, String bodyString) {
        LogItem logItem = new LogItem();
        logItem.setState_code(stateCode);
        logItem.setPlatform_time(String.valueOf(System.currentTimeMillis()));
        logItem.setLog_display_priority(priority);
        logItem.setUrl(targetUrl);
        logItem.setHeaders(headers);
        logItem.setData_key("");
        logItem.setBody(CompressUtil.compress(bodyString));
        return logItem;
    }

    public static String getSafeMapKey(Map<String, Object> stringObjectMap, String key) {
        return DapLogUtils.getSafeMapKey(stringObjectMap, key, "");
    }

    public static String getSafeMapKey(Map<String, Object> stringObjectMap, String key, String defaultValue) {
        if (null == stringObjectMap) {
            return defaultValue;
        }
        Object object = stringObjectMap.get(key);
        if (object != null) {
            return object.toString();
        }
        return defaultValue;
    }
}

