/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.eai;

import com.digiwin.app.eai.DWEAIFuseProperties;
import com.digiwin.gateway.fuse.DWReturnFuse;
import com.digiwin.gateway.fuse.exception.DWServerErrorException;
import com.digiwin.gateway.fuse.execute.DWFuseParameter;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DWEAIHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.json.JSONObject;

public class DWEAIFuse
implements DWReturnFuse<JSONObject> {
    public static final String KEY_RESPONSE_HTTP_STATUS = "eai-response-http-status";
    private static Log log = LogFactory.getLog(DWEAIFuse.class);
    private static CloseableHttpClient httpClient;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject execute(DWFuseParameter fuseParameter) throws Exception {
        HttpPost httpPost = (HttpPost)fuseParameter.get("httpPost");
        JSONObject responseJo = new JSONObject();
        String result = "";
        int statusCode = -1;
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
            JSONObject headerJo = new JSONObject();
            List<Header> headers = Arrays.asList(response.getAllHeaders());
            for (Header header222 : headers) {
                if (!header222.getName().startsWith("digi-")) continue;
                if ("digi-message".equalsIgnoreCase(header222.getName())) {
                    headerJo.put(header222.getName(), (Object)new String(Base64.getDecoder().decode(header222.getValue()), StandardCharsets.UTF_8));
                    continue;
                }
                headerJo.put(header222.getName(), (Object)header222.getValue());
            }
            responseJo.put("headers", (Object)headerJo);
            InputStream content = response.getEntity().getContent();
            if (content == null) {
                Header header222;
                responseJo.put("messageBody", (Object)"");
                header222 = responseJo;
                return header222;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(content, StandardCharsets.UTF_8);
            try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                StringBuffer stringBuffer = new StringBuffer("");
                String line = "";
                while ((line = bufferedReader.readLine()) != null) {
                    stringBuffer.append(line);
                }
                result = stringBuffer.toString();
                responseJo.put("messageBody", (Object)result);
            }
            statusCode = response.getStatusLine().getStatusCode();
            responseJo.put(KEY_RESPONSE_HTTP_STATUS, statusCode);
        }
        if (statusCode != 429 && statusCode != 502 && statusCode != 503) {
            if (statusCode != 504) return responseJo;
        }
        log.warn((Object)("[DWEAIFuse] HTTP Status Code: " + statusCode + ", result: " + result));
        throw new DWServerErrorException(statusCode, result);
    }

    static {
        String dwLegacyEaiHttpClientEnabled = System.getenv().get("dwLegacyEaiHttpClientEnabled");
        if (Boolean.parseBoolean(dwLegacyEaiHttpClientEnabled)) {
            PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
            manager.setMaxTotal(500);
            manager.setDefaultMaxPerRoute(500);
            httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)manager).build();
            IdleConnectionMonitorThread monitor = new IdleConnectionMonitorThread((HttpClientConnectionManager)manager);
            monitor.start();
        } else {
            httpClient = DWEAIHttpClient.create("DWEAIFuse", null, null);
        }
    }

    public static class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager manager;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(HttpClientConnectionManager manager) {
            this.manager = manager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(5000L);
                        this.manager.closeExpiredConnections();
                        long maxIdleTime = DWEAIFuseProperties.getHttpClientConnectionMaxIdleTime();
                        this.manager.closeIdleConnections(maxIdleTime, TimeUnit.MILLISECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException ex) {
                log.warn((Object)"Interrupted!", (Throwable)ex);
                Thread.currentThread().interrupt();
                this.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }
}

