/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.eai;

import com.digiwin.app.eai.DWEAIProperties;
import com.google.gson.Gson;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DigiHost {
    private String prod;
    private String ver;
    private String ip;
    private String id;
    private String lang;
    private String timezone;
    private String timestamp;
    private String acct;

    public DigiHost() {
        this.init();
    }

    public void init() {
        DWEAIProperties eaiProperties = DWEAIProperties.getProperties();
        this.prod = eaiProperties.getHostProd();
        this.ver = eaiProperties.getHostVer();
        this.ip = eaiProperties.getHostIp();
        this.id = eaiProperties.getHostId();
        this.timezone = this.getTimezoneOffset();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        this.timestamp = sdf.format(new Date());
    }

    public String getProd() {
        return this.prod;
    }

    public String getVer() {
        return this.ver;
    }

    public String getIp() {
        return this.ip;
    }

    public String getId() {
        return this.id;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(lang lang2) {
        this.lang = lang2.value();
    }

    public String getTimezone() {
        return this.timezone;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getAcct() {
        return this.acct;
    }

    public void setAcct(String acct) {
        this.acct = acct;
    }

    private String getTimezoneOffset() {
        TimeZone timeZone = TimeZone.getDefault();
        Calendar calendar = GregorianCalendar.getInstance(timeZone);
        int offsetInMillis = timeZone.getOffset(calendar.getTimeInMillis());
        Object offset = String.format("%d", Math.abs(offsetInMillis / 3600000));
        offset = (offsetInMillis >= 0 ? "+" : "-") + (String)offset;
        return offset;
    }

    public String toJSON() {
        String json = new Gson().toJson((Object)this);
        return json;
    }

    public static enum lang {
        zh_TW("zh_TW"),
        zh_CN("zh_CN"),
        en("en"),
        vi("vi");

        private String value;

        private lang(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

