/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container.exceptions;

import com.digiwin.app.container.exceptions.IDWException;
import java.util.HashMap;
import java.util.Map;

public class DWRuntimeException
extends RuntimeException
implements IDWException {
    private String errorCode;
    private Map<String, Object> errorInstructors;
    private String[] messageArgs;

    @Override
    public String getErrorType() {
        return "System";
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    public DWRuntimeException() {
    }

    public DWRuntimeException(String message) {
        super(message);
    }

    public DWRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    public DWRuntimeException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    public DWRuntimeException(String errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
    }

    public DWRuntimeException(String errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    @Override
    public Map<String, Object> getInstructors() {
        if (this.errorInstructors == null) {
            this.errorInstructors = new HashMap<String, Object>();
        }
        return this.errorInstructors;
    }

    @Override
    public String[] getMessageArgs() {
        return this.messageArgs;
    }

    public void setMessageArgs(String ... messageArgs) {
        this.messageArgs = messageArgs;
    }

    public DWRuntimeException(String errorCode, String message, String ... messageArgs) {
        this(errorCode, message, (Throwable)null, messageArgs);
    }

    public DWRuntimeException(String errorCode, String message, Throwable cause, String ... messageArgs) {
        super(String.format(message, messageArgs), cause);
        this.errorCode = errorCode;
        this.setMessageArgs(messageArgs);
    }
}

