/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.fuse.config;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.prometheus.client.CollectorRegistry;

public class OutboundConfig {
    private static final String TO_STRING_TEMPLATE = "{\"key\":\"%s\",\"enable\":\"%b\",\"failureRate\":\"%d\",\"openSec\":\"%d\",\"halfOpenCalculateSize\":\"%d\",\"closeCalculateSize\":\"%d\"}";
    private String key = "";
    private boolean enable = true;
    private int failureRate = 50;
    private int openSec = 60;
    private int halfOpenCalculateSize = 10;
    private int closeCalculateSize = 100;
    private boolean isCollectMetrics = false;
    private CollectorRegistry collectorRegistry = null;
    private CircuitBreaker circuitBreaker = null;

    public OutboundConfig(String key) {
        this.key = key;
    }

    public static OutboundConfig defaultConfig(String key) {
        return new OutboundConfig(key);
    }

    public String getKey() {
        return this.key;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public int getFailureRate() {
        return this.failureRate;
    }

    public void setFailureRate(int failureRate) {
        this.failureRate = failureRate;
    }

    public int getOpenSec() {
        return this.openSec;
    }

    public void setOpenSec(int openSec) {
        this.openSec = openSec;
    }

    public int getHalfOpenCalculateSize() {
        return this.halfOpenCalculateSize;
    }

    public void setHalfOpenCalculateSize(int halfOpenCalculateSize) {
        this.halfOpenCalculateSize = halfOpenCalculateSize;
    }

    public int getCloseCalculateSize() {
        return this.closeCalculateSize;
    }

    public void setCloseCalculateSize(int closeCalculateSize) {
        this.closeCalculateSize = closeCalculateSize;
    }

    public CollectorRegistry getCollectorRegistry() {
        if (!this.isCollectMetrics) {
            return null;
        }
        return this.collectorRegistry;
    }

    public void setCollectorRegistry(CollectorRegistry collectorRegistry) {
        this.collectorRegistry = collectorRegistry;
    }

    public CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public void setCircuitBreaker(CircuitBreaker circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
    }

    public String toString() {
        String s = String.format(TO_STRING_TEMPLATE, this.key, this.enable, this.failureRate, this.openSec, this.halfOpenCalculateSize, this.closeCalculateSize);
        return s;
    }

    public boolean isCollectMetrics() {
        return this.isCollectMetrics;
    }

    public void setCollectMetrics(boolean isCollectMetrics) {
        this.isCollectMetrics = isCollectMetrics;
    }
}

