/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.fuse.config;

import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.gateway.fuse.annotation.FuseOutbound;
import com.digiwin.gateway.fuse.config.DapPropertiesOutboundKey;
import com.digiwin.gateway.fuse.config.OutboundConfigBuilder;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.prometheus.client.CollectorRegistry;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.Environment;

public class OutboundConfig {
    private static final String TO_STRING_TEMPLATE = "{\"key\":\"%s\",\"enable\":\"%b\",\"failureRate\":\"%d\",\"openSec\":\"%d\",\"halfOpenCalculateSize\":\"%d\",\"closeCalculateSize\":\"%d\"}";
    private String key = "";
    private boolean enable = true;
    private int failureRate = 50;
    private int openSec = 60;
    private int halfOpenCalculateSize = 10;
    private int closeCalculateSize = 100;
    private boolean isCollectMetrics = false;
    private CollectorRegistry collectorRegistry = null;
    private CircuitBreaker circuitBreaker = null;

    public OutboundConfig(String key) {
        this.key = key;
    }

    public static OutboundConfig defaultConfig(String key) {
        return new OutboundConfig(key);
    }

    public String getKey() {
        return this.key;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public int getFailureRate() {
        return this.failureRate;
    }

    public void setFailureRate(int failureRate) {
        this.failureRate = failureRate;
    }

    public int getOpenSec() {
        return this.openSec;
    }

    public void setOpenSec(int openSec) {
        this.openSec = openSec;
    }

    public int getHalfOpenCalculateSize() {
        return this.halfOpenCalculateSize;
    }

    public void setHalfOpenCalculateSize(int halfOpenCalculateSize) {
        this.halfOpenCalculateSize = halfOpenCalculateSize;
    }

    public int getCloseCalculateSize() {
        return this.closeCalculateSize;
    }

    public void setCloseCalculateSize(int closeCalculateSize) {
        this.closeCalculateSize = closeCalculateSize;
    }

    public CollectorRegistry getCollectorRegistry() {
        if (!this.isCollectMetrics) {
            return null;
        }
        return this.collectorRegistry;
    }

    public void setCollectorRegistry(CollectorRegistry collectorRegistry) {
        this.collectorRegistry = collectorRegistry;
    }

    public CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public void setCircuitBreaker(CircuitBreaker circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
    }

    public String toString() {
        String s = String.format(TO_STRING_TEMPLATE, this.key, this.enable, this.failureRate, this.openSec, this.halfOpenCalculateSize, this.closeCalculateSize);
        return s;
    }

    public boolean isCollectMetrics() {
        return this.isCollectMetrics;
    }

    public void setCollectMetrics(boolean isCollectMetrics) {
        this.isCollectMetrics = isCollectMetrics;
    }

    public static OutboundConfig create(String prefix, String key) {
        String parameterKey = prefix + "." + key;
        Environment environment = SpringContextUtils.getEnvironment();
        String enableKey = DapPropertiesOutboundKey.enable(parameterKey);
        String failureRateKey = DapPropertiesOutboundKey.failureRate(parameterKey);
        String openSecKey = DapPropertiesOutboundKey.openSec(parameterKey);
        String halfOpenCalculateSizeKey = DapPropertiesOutboundKey.halfOpenCalculateSize(parameterKey);
        String closeCalculateSizeKey = DapPropertiesOutboundKey.closeCalculateSize(parameterKey);
        String enable = environment.getProperty(enableKey);
        String failureRate = environment.getProperty(failureRateKey);
        String openSec = environment.getProperty(openSecKey);
        String halfOpenCalculateSize = environment.getProperty(halfOpenCalculateSizeKey);
        String closeCalculateSize = environment.getProperty(closeCalculateSizeKey);
        if (StringUtils.isBlank((CharSequence)enable)) {
            enable = environment.getProperty(DapPropertiesOutboundKey.enable(prefix), "false");
        }
        if (StringUtils.isBlank((CharSequence)failureRate)) {
            failureRate = environment.getProperty(DapPropertiesOutboundKey.failureRate(prefix), String.valueOf(50));
        }
        if (StringUtils.isBlank((CharSequence)openSec)) {
            openSec = environment.getProperty(DapPropertiesOutboundKey.openSec(prefix), String.valueOf(60));
        }
        if (StringUtils.isBlank((CharSequence)halfOpenCalculateSize)) {
            halfOpenCalculateSize = environment.getProperty(DapPropertiesOutboundKey.halfOpenCalculateSize(prefix), String.valueOf(10));
        }
        if (StringUtils.isBlank((CharSequence)closeCalculateSize)) {
            closeCalculateSize = environment.getProperty(DapPropertiesOutboundKey.closeCalculateSize(prefix), String.valueOf(100));
        }
        OutboundConfig outboundConfig = new OutboundConfigBuilder(parameterKey).enable(enable).failureRate(failureRate).openSec(openSec).halfOpenCalculateSize(halfOpenCalculateSize).closeCalculateSize(closeCalculateSize).build();
        return outboundConfig;
    }

    public static OutboundConfig create(String key) {
        Environment environment = SpringContextUtils.getEnvironment();
        String enableKey = DapPropertiesOutboundKey.enable(key);
        String failureRateKey = DapPropertiesOutboundKey.failureRate(key);
        String openSecKey = DapPropertiesOutboundKey.openSec(key);
        String halfOpenCalculateSizeKey = DapPropertiesOutboundKey.halfOpenCalculateSize(key);
        String closeCalculateSizeKey = DapPropertiesOutboundKey.closeCalculateSize(key);
        String enable = environment.getProperty(enableKey, "false");
        String failureRate = environment.getProperty(failureRateKey, String.valueOf(50));
        String openSec = environment.getProperty(openSecKey, String.valueOf(60));
        String halfOpenCalculateSize = environment.getProperty(halfOpenCalculateSizeKey, String.valueOf(10));
        String closeCalculateSize = environment.getProperty(closeCalculateSizeKey, String.valueOf(100));
        OutboundConfig outboundConfig = new OutboundConfigBuilder(key).enable(enable).failureRate(failureRate).openSec(openSec).halfOpenCalculateSize(halfOpenCalculateSize).closeCalculateSize(closeCalculateSize).build();
        return outboundConfig;
    }

    public static OutboundConfig create(FuseOutbound fuseOutbound) {
        Environment environment = SpringContextUtils.getEnvironment();
        String parameterKey = fuseOutbound.key();
        String enableKey = DapPropertiesOutboundKey.enable(parameterKey);
        String failureRateKey = DapPropertiesOutboundKey.failureRate(parameterKey);
        String openSecKey = DapPropertiesOutboundKey.openSec(parameterKey);
        String halfOpenCalculateSizeKey = DapPropertiesOutboundKey.halfOpenCalculateSize(parameterKey);
        String closeCalculateSizeKey = DapPropertiesOutboundKey.closeCalculateSize(parameterKey);
        String enable = environment.getProperty(enableKey, String.valueOf(fuseOutbound.enable()));
        String failureRate = environment.getProperty(failureRateKey, String.valueOf(fuseOutbound.failureRate()));
        String openSec = environment.getProperty(openSecKey, String.valueOf(fuseOutbound.openSec()));
        String halfOpenCalculateSize = environment.getProperty(halfOpenCalculateSizeKey, String.valueOf(fuseOutbound.halfOpenCalculateSize()));
        String closeCalculateSize = environment.getProperty(closeCalculateSizeKey, String.valueOf(fuseOutbound.closeCalculateSize()));
        OutboundConfig outboundConfig = new OutboundConfigBuilder(parameterKey).enable(enable).failureRate(failureRate).openSec(openSec).halfOpenCalculateSize(halfOpenCalculateSize).closeCalculateSize(closeCalculateSize).build();
        return outboundConfig;
    }
}

