/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.fuse.execute;

import com.digiwin.gateway.fuse.DWCircuitBreaker;
import com.digiwin.gateway.fuse.DWRateLimiter;
import com.digiwin.gateway.fuse.DWReturnFuse;
import com.digiwin.gateway.fuse.DWVoidFuse;
import com.digiwin.gateway.fuse.execute.DWFuseBlockingQueue;
import com.digiwin.gateway.fuse.execute.DWFuseExecuteStatus;
import com.digiwin.gateway.fuse.execute.DWFuseOption;
import com.digiwin.gateway.fuse.execute.DWFuseParameter;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.internal.AtomicRateLimiter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExecuteWrapper<T> {
    private static Log log = LogFactory.getLog(ExecuteWrapper.class);
    private DWFuseBlockingQueue<T> fuseBlockingQueue = new DWFuseBlockingQueue();
    private DWFuseExecuteStatus fuseExecuteStatus = new DWFuseExecuteStatus();
    private DWReturnFuse<T> returnFuse;
    private DWVoidFuse voidFuse;
    private DWFuseParameter fuseParameter;
    private DWRateLimiter dwRateLimiter;
    private DWCircuitBreaker dwCircuitBreaker;
    private Runnable runnable;
    private DWFuseOption option = new DWFuseOption();

    public DWFuseBlockingQueue<T> getFuseBlockingQueue() {
        return this.fuseBlockingQueue;
    }

    public DWFuseExecuteStatus getFuseExecuteStatus() {
        return this.fuseExecuteStatus;
    }

    public DWReturnFuse<T> getReturnFuse() {
        return this.returnFuse;
    }

    public void setReturnFuse(DWReturnFuse<T> returnFuse) {
        this.returnFuse = returnFuse;
    }

    public DWVoidFuse getVoidFuse() {
        return this.voidFuse;
    }

    public void setVoidFuse(DWVoidFuse voidFuse) {
        this.voidFuse = voidFuse;
    }

    public DWFuseParameter getFuseParameter() {
        return this.fuseParameter;
    }

    public void setFuseParameter(DWFuseParameter fuseParameter) {
        this.fuseParameter = fuseParameter;
    }

    public void setDWRateLimiter(DWRateLimiter dwRateLimiter) {
        this.dwRateLimiter = dwRateLimiter;
    }

    public void setDWCircuitBreaker(DWCircuitBreaker dwCircuitBreaker) {
        this.dwCircuitBreaker = dwCircuitBreaker;
    }

    private AtomicRateLimiter.AtomicRateLimiterMetrics getRateLimiterMetrics() {
        try {
            RateLimiter rateLimiter = this.dwRateLimiter.getRateLimiter();
            RateLimiter.Metrics metrics = rateLimiter.getMetrics();
            if (metrics instanceof AtomicRateLimiter.AtomicRateLimiterMetrics) {
                AtomicRateLimiter.AtomicRateLimiterMetrics atomicRateLimiterMetrics = (AtomicRateLimiter.AtomicRateLimiterMetrics)metrics;
                return atomicRateLimiterMetrics;
            }
        }
        catch (Exception e) {
            log.debug((Object)("[Metrics] " + e.getMessage()));
        }
        return null;
    }

    public int getRemaining() {
        int remaining = -1;
        AtomicRateLimiter.AtomicRateLimiterMetrics atomicRateLimiterMetrics = this.getRateLimiterMetrics();
        if (atomicRateLimiterMetrics != null) {
            remaining = atomicRateLimiterMetrics.getAvailablePermissions();
        }
        return remaining;
    }

    public long getReset() {
        long reset = -1L;
        AtomicRateLimiter.AtomicRateLimiterMetrics atomicRateLimiterMetrics = this.getRateLimiterMetrics();
        if (atomicRateLimiterMetrics != null) {
            reset = atomicRateLimiterMetrics.getNanosToWait();
        }
        return reset;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public void setRunnable(Runnable runnable) {
        this.runnable = runnable;
    }

    public DWFuseOption getOption() {
        return this.option;
    }

    public void setOption(DWFuseOption option) {
        this.option = option;
    }
}

