/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.fuse.config;

import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.gateway.fuse.annotation.FuseInbound;
import com.digiwin.gateway.fuse.config.DapPropertiesInboundKey;
import com.digiwin.gateway.fuse.config.InboundConfigBuilder;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.prometheus.client.CollectorRegistry;
import org.springframework.core.env.Environment;

public class InboundConfig {
    private static final String TO_STRING_TEMPLATE = "{\"key\":\"%s\",\"enable\":\"%b\",\"maxWaitSec\":\"%d\",\"limit\":\"%d\",\"resetNanoSec\":\"%d\"}";
    private String key = "";
    private boolean enable = true;
    private int maxWaitSec = 5;
    private int limit = 50;
    private long resetNanoSec = 500L;
    private boolean isCollectMetrics = false;
    private CollectorRegistry collectorRegistry = null;
    private RateLimiter rateLimiter = null;

    public InboundConfig(String key) {
        this.key = key;
    }

    public static InboundConfig defaultConfig(String key) {
        return new InboundConfig(key);
    }

    public String getKey() {
        return this.key;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public int getMaxWaitSec() {
        return this.maxWaitSec;
    }

    public void setMaxWaitSec(int maxWaitSec) {
        this.maxWaitSec = maxWaitSec;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public long getResetNanoSec() {
        return this.resetNanoSec;
    }

    public void setResetNanoSec(long resetNanoSec) {
        this.resetNanoSec = resetNanoSec;
    }

    public CollectorRegistry getCollectorRegistry() {
        if (!this.isCollectMetrics) {
            return null;
        }
        return this.collectorRegistry;
    }

    public void setCollectorRegistry(CollectorRegistry collectorRegistry) {
        this.collectorRegistry = collectorRegistry;
    }

    public RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public void setRateLimiter(RateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public String toString() {
        String s = String.format(TO_STRING_TEMPLATE, this.key, this.enable, this.maxWaitSec, this.limit, this.resetNanoSec);
        return s;
    }

    public boolean isCollectMetrics() {
        return this.isCollectMetrics;
    }

    public void setCollectMetrics(boolean isCollectMetrics) {
        this.isCollectMetrics = isCollectMetrics;
    }

    public static InboundConfig create(FuseInbound fuseInbound) {
        Environment environment = SpringContextUtils.getEnvironment();
        String parameterKey = fuseInbound.key();
        String enableKey = DapPropertiesInboundKey.enable(parameterKey);
        String maxWaitSecKey = DapPropertiesInboundKey.maxWaitSec(parameterKey);
        String limitKey = DapPropertiesInboundKey.limit(parameterKey);
        String resetNanoSecKey = DapPropertiesInboundKey.resetNanoSec(parameterKey);
        String enable = environment.getProperty(enableKey, String.valueOf(fuseInbound.enable()));
        String maxWaitSec = environment.getProperty(maxWaitSecKey, String.valueOf(fuseInbound.maxWaitSec()));
        String limit = environment.getProperty(limitKey, String.valueOf(fuseInbound.limit()));
        String resetNanoSec = environment.getProperty(resetNanoSecKey, String.valueOf(fuseInbound.resetNanoSec()));
        InboundConfig inboundConfig = new InboundConfigBuilder(parameterKey).enable(enable).maxWaitSec(maxWaitSec).limit(limit).resetNanoSec(resetNanoSec).build();
        return inboundConfig;
    }
}

