/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.fuse;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class XRateLimitHeader {
    private static Log log = LogFactory.getLog(XRateLimitHeader.class);

    public static void set(int remaining, long reset) {
        XRateLimitHeader.set(false, remaining, reset);
    }

    public static void set(boolean isIgnoreUnassigned, int remaining, long reset) {
        try {
            RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
            HttpServletResponse response = ((ServletRequestAttributes)requestAttributes).getResponse();
            Objects.requireNonNull(response);
            if (isIgnoreUnassigned) {
                if (remaining != -1) {
                    response.addHeader("X-RateLimit-Remaining", String.valueOf(remaining));
                }
                if (reset != -1L) {
                    response.addHeader("X-RateLimit-Reset", String.valueOf(reset));
                }
            } else {
                response.addHeader("X-RateLimit-Remaining", String.valueOf(remaining));
                response.addHeader("X-RateLimit-Reset", String.valueOf(reset));
            }
        }
        catch (IllegalStateException ignoredIllegalStateException) {
            log.debug((Object)("[XRateLimitHeader] " + ignoredIllegalStateException.getMessage()));
        }
        catch (Exception ignoredException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            ignoredException.printStackTrace(printWriter);
            String stackTrace = stringWriter.toString();
            log.error((Object)("[XRateLimitHeader] " + ignoredException.getMessage()));
            log.error((Object)("[XRateLimitHeader] " + stackTrace));
        }
    }
}

