/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.fuse.registry;

import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.registry.AbstractRegistry;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.ratelimiter.internal.AtomicRateLimiter;
import io.vavr.collection.Array;
import io.vavr.collection.Seq;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class DWRateLimiterRegistry
extends AbstractRegistry<RateLimiter, RateLimiterConfig>
implements RateLimiterRegistry {
    public DWRateLimiterRegistry() {
        this(RateLimiterConfig.ofDefaults());
    }

    public DWRateLimiterRegistry(Map<String, RateLimiterConfig> configs) {
        this(configs.getOrDefault("default", RateLimiterConfig.ofDefaults()));
        this.configurations.putAll(configs);
    }

    public DWRateLimiterRegistry(Map<String, RateLimiterConfig> configs, RegistryEventConsumer<RateLimiter> registryEventConsumer) {
        this(configs.getOrDefault("default", RateLimiterConfig.ofDefaults()), registryEventConsumer);
        this.configurations.putAll(configs);
    }

    public DWRateLimiterRegistry(Map<String, RateLimiterConfig> configs, List<RegistryEventConsumer<RateLimiter>> registryEventConsumers) {
        this(configs.getOrDefault("default", RateLimiterConfig.ofDefaults()), registryEventConsumers);
        this.configurations.putAll(configs);
    }

    public DWRateLimiterRegistry(RateLimiterConfig defaultConfig) {
        super((Object)defaultConfig);
    }

    public DWRateLimiterRegistry(RateLimiterConfig defaultConfig, RegistryEventConsumer<RateLimiter> registryEventConsumer) {
        super((Object)defaultConfig, registryEventConsumer);
    }

    public DWRateLimiterRegistry(RateLimiterConfig defaultConfig, List<RegistryEventConsumer<RateLimiter>> registryEventConsumers) {
        super((Object)defaultConfig, registryEventConsumers);
    }

    public Seq<RateLimiter> getAllRateLimiters() {
        return Array.ofAll(this.entryMap.values());
    }

    public RateLimiter rateLimiter(String name) {
        return this.rateLimiter(name, (RateLimiterConfig)this.getDefaultConfig());
    }

    public RateLimiter rateLimiter(String name, RateLimiterConfig config) {
        Supplier<RateLimiter> supplier = () -> new AtomicRateLimiter(name, Objects.requireNonNull(config, "Config must not be null"));
        return this.rateLimiter(name, config, supplier);
    }

    public RateLimiter rateLimiter(String name, Supplier<RateLimiterConfig> rateLimiterConfigSupplier) {
        RateLimiterConfig config = rateLimiterConfigSupplier.get();
        Supplier<RateLimiter> supplier = () -> new AtomicRateLimiter(name, (RateLimiterConfig)Objects.requireNonNull(Objects.requireNonNull(rateLimiterConfigSupplier, "Supplier must not be null").get(), "Config must not be null"));
        return this.rateLimiter(name, config, supplier);
    }

    public RateLimiter rateLimiter(String name, String configName) {
        Optional optional = this.getConfiguration(configName);
        if (!optional.isPresent()) {
            throw new NoSuchElementException();
        }
        RateLimiterConfig config = (RateLimiterConfig)optional.get();
        Supplier<RateLimiter> supplier = () -> RateLimiter.of((String)name, (RateLimiterConfig)((RateLimiterConfig)this.getConfiguration(configName).orElseThrow(() -> new ConfigurationNotFoundException(configName))));
        return this.rateLimiter(name, config, supplier);
    }

    private RateLimiter rateLimiter(String name, RateLimiterConfig config, Supplier<RateLimiter> supplier) {
        Optional findEntry = this.find(name);
        if (findEntry.isPresent()) {
            RateLimiter findRateLimiter = (RateLimiter)findEntry.get();
            RateLimiterConfig findRateLimiterConfig = findRateLimiter.getRateLimiterConfig();
            if (this.isConfigEqual(config, findRateLimiterConfig)) {
                return (RateLimiter)this.computeIfAbsent(name, supplier);
            }
            this.remove(name);
            return (RateLimiter)this.computeIfAbsent(name, supplier);
        }
        return (RateLimiter)this.computeIfAbsent(name, supplier);
    }

    private boolean isConfigEqual(RateLimiterConfig config1, RateLimiterConfig config2) {
        int limitForPeriod1 = config1.getLimitForPeriod();
        Duration limitRefreshPeriod1 = config1.getLimitRefreshPeriod();
        Duration timeoutDuration1 = config1.getTimeoutDuration();
        int limitForPeriod2 = config2.getLimitForPeriod();
        Duration limitRefreshPeriod2 = config2.getLimitRefreshPeriod();
        Duration timeoutDuration2 = config2.getTimeoutDuration();
        return limitForPeriod1 == limitForPeriod2 && limitRefreshPeriod1.equals(limitRefreshPeriod2) && timeoutDuration1.equals(timeoutDuration2);
    }
}

