/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.fuse;

import com.digiwin.gateway.fuse.DWFuseDecorator;
import com.digiwin.gateway.fuse.DWReturnFuse;
import com.digiwin.gateway.fuse.DWVoidFuse;
import com.digiwin.gateway.fuse.DummyNull;
import com.digiwin.gateway.fuse.FuseHttpStatusCode;
import com.digiwin.gateway.fuse.XRateLimitHeader;
import com.digiwin.gateway.fuse.config.InboundConfig;
import com.digiwin.gateway.fuse.config.OutboundConfig;
import com.digiwin.gateway.fuse.exception.DWBrokenCircuitException;
import com.digiwin.gateway.fuse.exception.DWFuseBusinessException;
import com.digiwin.gateway.fuse.exception.DWFuseRuntimeException;
import com.digiwin.gateway.fuse.exception.DWOverLimitException;
import com.digiwin.gateway.fuse.execute.DWFuseBlockingQueue;
import com.digiwin.gateway.fuse.execute.DWFuseExecuteStatus;
import com.digiwin.gateway.fuse.execute.DWFuseOption;
import com.digiwin.gateway.fuse.execute.DWFuseParameter;
import com.digiwin.gateway.fuse.execute.DWFuseReturnResponse;
import com.digiwin.gateway.fuse.execute.DWFuseRunnable;
import com.digiwin.gateway.fuse.execute.DWFuseVoidResponse;
import com.digiwin.gateway.fuse.execute.DecoratorWrapper;
import com.digiwin.gateway.fuse.execute.ExecuteWrapper;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.vavr.control.Try;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWFuseExecutor {
    private static Log log = LogFactory.getLog(DWFuseExecutor.class);

    private static <T> DWFuseReturnResponse<T> onExecute(ExecuteWrapper<T> executeWrapper, InboundConfig inboundConfig, OutboundConfig outboundConfig) throws Exception, DWOverLimitException, DWBrokenCircuitException {
        DecoratorWrapper decoratorWrapper;
        DWFuseOption option = executeWrapper.getOption();
        boolean isCollectMetrics = option.isCollectMetrics();
        boolean isAutoFuseHttpStatusCode = option.isAutoFuseHttpStatusCode();
        Runnable runnable = executeWrapper.getRunnable();
        if (outboundConfig != null) {
            outboundConfig.setCollectMetrics(isCollectMetrics);
            decoratorWrapper = DWFuseDecorator.get(runnable, outboundConfig);
            runnable = decoratorWrapper.getRunnable();
            executeWrapper.setDWCircuitBreaker(decoratorWrapper.getDWCircuitBreaker());
        }
        if (inboundConfig != null) {
            inboundConfig.setCollectMetrics(isCollectMetrics);
            decoratorWrapper = DWFuseDecorator.get(runnable, inboundConfig);
            runnable = decoratorWrapper.getRunnable();
            executeWrapper.setDWRateLimiter(decoratorWrapper.getDWRateLimiter());
        }
        Try.runRunnable((Runnable)runnable).onFailure(e -> {
            executeWrapper.getFuseExecuteStatus().setInterrupt(true);
            executeWrapper.getFuseExecuteStatus().setDone(true);
            DWFuseBlockingQueue fuseBlockingQueue = executeWrapper.getFuseBlockingQueue();
            BlockingQueue<Throwable> exceptionBlockingQueue = fuseBlockingQueue.getExceptionBlockingQueue();
            if (e instanceof DWFuseBusinessException) {
                exceptionBlockingQueue.add(((DWFuseBusinessException)e).getThrowable());
                return;
            }
            if (e instanceof DWFuseRuntimeException) {
                exceptionBlockingQueue.add(((DWFuseRuntimeException)e).getThrowable());
                return;
            }
            exceptionBlockingQueue.add((Throwable)e);
        });
        boolean isDone = false;
        while (!isDone) {
            isDone = executeWrapper.getFuseExecuteStatus().isDone();
        }
        DWFuseBlockingQueue<T> fuseBlockingQueue = executeWrapper.getFuseBlockingQueue();
        DWFuseExecuteStatus fuseExecuteStatus = executeWrapper.getFuseExecuteStatus();
        int remaining = executeWrapper.getRemaining();
        long reset = executeWrapper.getReset();
        boolean isXRateLimitHeaderOn = executeWrapper.getOption().isXRateLimitHeaderOn();
        if (isXRateLimitHeaderOn) {
            boolean isIgnoreUnassignedXRateLimitHeader = executeWrapper.getOption().isIgnoreUnassignedXRateLimitHeader();
            XRateLimitHeader.set(isIgnoreUnassignedXRateLimitHeader, remaining, reset);
        }
        if (fuseExecuteStatus.isInterrupt()) {
            Throwable throwable = fuseBlockingQueue.getExceptionBlockingQueue().take();
            if (throwable instanceof CallNotPermittedException) {
                int outboundErrorHttpStatusCode = option.getOutboundErrorHttpStatusCode();
                if (isAutoFuseHttpStatusCode) {
                    FuseHttpStatusCode.set(outboundErrorHttpStatusCode);
                }
                if (outboundConfig != null) {
                    String key = outboundConfig.getKey();
                    log.warn((Object)("[Outbound] " + key));
                }
                String message = ((CallNotPermittedException)throwable).getMessage();
                log.warn((Object)("[Outbound] " + message));
                DWBrokenCircuitException brokenCircuitException = new DWBrokenCircuitException(message);
                brokenCircuitException.setAutoFuseHttpStatusCode(isAutoFuseHttpStatusCode);
                brokenCircuitException.setStatusCode(outboundErrorHttpStatusCode);
                throw brokenCircuitException;
            }
            if (throwable instanceof RequestNotPermitted) {
                int inboundErrorHttpStatusCode = option.getInboundErrorHttpStatusCode();
                if (isAutoFuseHttpStatusCode) {
                    FuseHttpStatusCode.set(inboundErrorHttpStatusCode);
                }
                if (inboundConfig != null) {
                    String key = inboundConfig.getKey();
                    log.warn((Object)("[Inbound] " + key));
                }
                String message = ((RequestNotPermitted)throwable).getMessage();
                log.warn((Object)("[Inbound] " + message));
                DWOverLimitException overLimitException = new DWOverLimitException(message);
                overLimitException.setRemaining(remaining);
                overLimitException.setReset(reset);
                overLimitException.setAutoFuseHttpStatusCode(isAutoFuseHttpStatusCode);
                overLimitException.setStatusCode(inboundErrorHttpStatusCode);
                throw overLimitException;
            }
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new Exception(throwable);
        }
        DWFuseReturnResponse<T> fuseReturnResponse = new DWFuseReturnResponse<T>();
        fuseReturnResponse.setRemaining(remaining);
        fuseReturnResponse.setReset(reset);
        if (fuseExecuteStatus.isNull()) {
            fuseReturnResponse.setResponse(null);
            return fuseReturnResponse;
        }
        T result = fuseBlockingQueue.getBlockingQueue().take();
        if (result instanceof DummyNull) {
            fuseReturnResponse.setResponse(null);
            return fuseReturnResponse;
        }
        fuseReturnResponse.setResponse(result);
        return fuseReturnResponse;
    }

    public static <T> DWFuseReturnResponse<T> execute(DWReturnFuse<T> returnFuse, DWFuseParameter fuseParameter, InboundConfig inboundConfig, OutboundConfig outboundConfig) throws Exception, DWOverLimitException, DWBrokenCircuitException {
        return DWFuseExecutor.execute(returnFuse, fuseParameter, inboundConfig, outboundConfig, new DWFuseOption());
    }

    public static <T> DWFuseReturnResponse<T> execute(DWReturnFuse<T> returnFuse, DWFuseParameter fuseParameter, InboundConfig inboundConfig, OutboundConfig outboundConfig, DWFuseOption option) throws Exception, DWOverLimitException, DWBrokenCircuitException {
        ExecuteWrapper<T> executeWrapper = new ExecuteWrapper<T>();
        executeWrapper.setFuseParameter(fuseParameter);
        executeWrapper.setOption(option);
        executeWrapper.setReturnFuse(returnFuse);
        Runnable runnable = DWFuseRunnable.getReturnRunnable(executeWrapper);
        executeWrapper.setRunnable(runnable);
        DWFuseReturnResponse fuseReturnResponse = DWFuseExecutor.onExecute(executeWrapper, inboundConfig, outboundConfig);
        return fuseReturnResponse;
    }

    public static <T> DWFuseReturnResponse<T> execute(DWReturnFuse<T> returnFuse, DWFuseParameter fuseParameter, InboundConfig inboundConfig) throws Exception, DWOverLimitException, DWBrokenCircuitException {
        return DWFuseExecutor.execute(returnFuse, fuseParameter, inboundConfig, new DWFuseOption());
    }

    public static <T> DWFuseReturnResponse<T> execute(DWReturnFuse<T> returnFuse, DWFuseParameter fuseParameter, InboundConfig inboundConfig, DWFuseOption option) throws Exception, DWOverLimitException, DWBrokenCircuitException {
        DWFuseReturnResponse<T> fuseReturnResponse = DWFuseExecutor.execute(returnFuse, fuseParameter, inboundConfig, null, option);
        return fuseReturnResponse;
    }

    public static <T> DWFuseReturnResponse<T> execute(DWReturnFuse<T> returnFuse, DWFuseParameter fuseParameter, OutboundConfig outboundConfig) throws Exception, DWOverLimitException, DWBrokenCircuitException {
        return DWFuseExecutor.execute(returnFuse, fuseParameter, outboundConfig, new DWFuseOption());
    }

    public static <T> DWFuseReturnResponse<T> execute(DWReturnFuse<T> returnFuse, DWFuseParameter fuseParameter, OutboundConfig outboundConfig, DWFuseOption option) throws Exception, DWOverLimitException, DWBrokenCircuitException {
        DWFuseReturnResponse<T> fuseReturnResponse = DWFuseExecutor.execute(returnFuse, fuseParameter, null, outboundConfig, option);
        return fuseReturnResponse;
    }

    public static DWFuseVoidResponse execute(DWVoidFuse voidFuse, DWFuseParameter fuseParameter, InboundConfig inboundConfig, OutboundConfig outboundConfig) throws Exception, DWOverLimitException, DWBrokenCircuitException {
        return DWFuseExecutor.execute(voidFuse, fuseParameter, inboundConfig, outboundConfig, new DWFuseOption());
    }

    public static DWFuseVoidResponse execute(DWVoidFuse voidFuse, DWFuseParameter fuseParameter, InboundConfig inboundConfig, OutboundConfig outboundConfig, DWFuseOption option) throws Exception, DWOverLimitException, DWBrokenCircuitException {
        ExecuteWrapper<DummyNull> executeWrapper = new ExecuteWrapper<DummyNull>();
        executeWrapper.setFuseParameter(fuseParameter);
        executeWrapper.setOption(option);
        executeWrapper.setVoidFuse(voidFuse);
        Runnable runnable = DWFuseRunnable.getVoidRunnable(executeWrapper);
        executeWrapper.setRunnable(runnable);
        DWFuseReturnResponse<DummyNull> fuseReturnResponse = DWFuseExecutor.onExecute(executeWrapper, inboundConfig, outboundConfig);
        DWFuseVoidResponse fuseVoidResponse = new DWFuseVoidResponse();
        fuseVoidResponse.setRemaining(fuseReturnResponse.getRemaining());
        fuseVoidResponse.setReset(fuseReturnResponse.getReset());
        return fuseVoidResponse;
    }

    public static DWFuseVoidResponse execute(DWVoidFuse voidFuse, DWFuseParameter fuseParameter, InboundConfig inboundConfig) throws Exception, DWOverLimitException, DWBrokenCircuitException {
        return DWFuseExecutor.execute(voidFuse, fuseParameter, inboundConfig, new DWFuseOption());
    }

    public static DWFuseVoidResponse execute(DWVoidFuse voidFuse, DWFuseParameter fuseParameter, InboundConfig inboundConfig, DWFuseOption option) throws Exception, DWOverLimitException, DWBrokenCircuitException {
        DWFuseVoidResponse fuseVoidResponse = DWFuseExecutor.execute(voidFuse, fuseParameter, inboundConfig, null, option);
        return fuseVoidResponse;
    }

    public static DWFuseVoidResponse execute(DWVoidFuse voidFuse, DWFuseParameter fuseParameter, OutboundConfig outboundConfig) throws Exception, DWOverLimitException, DWBrokenCircuitException {
        return DWFuseExecutor.execute(voidFuse, fuseParameter, outboundConfig, new DWFuseOption());
    }

    public static DWFuseVoidResponse execute(DWVoidFuse voidFuse, DWFuseParameter fuseParameter, OutboundConfig outboundConfig, DWFuseOption option) throws Exception, DWOverLimitException, DWBrokenCircuitException {
        DWFuseVoidResponse fuseVoidResponsee = DWFuseExecutor.execute(voidFuse, fuseParameter, null, outboundConfig, option);
        return fuseVoidResponsee;
    }
}

