/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.fuse.execute;

import com.digiwin.gateway.fuse.DWReturnFuse;
import com.digiwin.gateway.fuse.DWVoidFuse;
import com.digiwin.gateway.fuse.DummyNull;
import com.digiwin.gateway.fuse.exception.DWFuseBusinessException;
import com.digiwin.gateway.fuse.exception.DWFuseRuntimeException;
import com.digiwin.gateway.fuse.execute.DWFuseBlockingQueue;
import com.digiwin.gateway.fuse.execute.DWFuseExecuteStatus;
import com.digiwin.gateway.fuse.execute.DWFuseParameter;
import com.digiwin.gateway.fuse.execute.ExecuteWrapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWFuseRunnable {
    private static Log log = LogFactory.getLog(DWFuseRunnable.class);

    public static <T> Runnable getReturnRunnable(ExecuteWrapper<T> executeWrapper) {
        Consumer consumer = DWFuseRunnable.getReturnConsumer();
        Runnable runnable = () -> consumer.accept(executeWrapper);
        return runnable;
    }

    public static Runnable getVoidRunnable(ExecuteWrapper<DummyNull> executeWrapper) {
        Consumer<ExecuteWrapper<DummyNull>> consumer = DWFuseRunnable.getVoidConsumer();
        Runnable runnable = () -> consumer.accept(executeWrapper);
        return runnable;
    }

    private static <T> Consumer<ExecuteWrapper<T>> getReturnConsumer() {
        Consumer<ExecuteWrapper<T>> returnConsumer = executeWrapper -> {
            DWFuseBlockingQueue fuseBlockingQueue = executeWrapper.getFuseBlockingQueue();
            DWFuseExecuteStatus fuseExecuteStatus = executeWrapper.getFuseExecuteStatus();
            DWReturnFuse returnFuse = executeWrapper.getReturnFuse();
            DWFuseParameter fuseParameter = executeWrapper.getFuseParameter();
            try {
                Object result = returnFuse.execute(fuseParameter);
                if (result == null) {
                    fuseBlockingQueue.getNullBlockingQueue().add(new DummyNull());
                    fuseExecuteStatus.setNull(true);
                } else {
                    fuseBlockingQueue.getBlockingQueue().add(result);
                    fuseExecuteStatus.setNull(false);
                }
                fuseExecuteStatus.setInterrupt(false);
                fuseExecuteStatus.setDone(true);
                return;
            }
            catch (Throwable t) {
                fuseExecuteStatus.setInterrupt(true);
                fuseExecuteStatus.setNull(false);
                fuseExecuteStatus.setDone(true);
                try {
                    Class<?> businessExceptionClass = Class.forName("com.digiwin.app.container.exceptions.DWBusinessException");
                    Class<?> throwableClass = t.getClass();
                    Class<?> throwableCauseClass = null;
                    if (t.getCause() != null) {
                        throwableCauseClass = t.getCause().getClass();
                    }
                    if (businessExceptionClass.equals(throwableClass) || businessExceptionClass.equals(throwableCauseClass)) {
                        throw new DWFuseBusinessException(t);
                    }
                    throw new DWFuseRuntimeException(t);
                }
                catch (ClassNotFoundException e) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    e.printStackTrace(printWriter);
                    String stackTrace = stringWriter.toString();
                    log.debug((Object)("[ReturnConsumer] " + e.getMessage()));
                    log.debug((Object)("[ReturnConsumer] " + stackTrace));
                    throw new DWFuseRuntimeException(t);
                }
            }
        };
        return returnConsumer;
    }

    private static Consumer<ExecuteWrapper<DummyNull>> getVoidConsumer() {
        Consumer<ExecuteWrapper<DummyNull>> voidConsumer = executeWrapper -> {
            DWFuseBlockingQueue fuseBlockingQueue = executeWrapper.getFuseBlockingQueue();
            DWFuseExecuteStatus fuseExecuteStatus = executeWrapper.getFuseExecuteStatus();
            DWVoidFuse voidFuse = executeWrapper.getVoidFuse();
            DWFuseParameter fuseParameter = executeWrapper.getFuseParameter();
            try {
                voidFuse.execute(fuseParameter);
                fuseBlockingQueue.getBlockingQueue().add(new DummyNull());
                fuseExecuteStatus.setInterrupt(false);
                fuseExecuteStatus.setNull(true);
                fuseExecuteStatus.setDone(true);
                return;
            }
            catch (Throwable t) {
                fuseExecuteStatus.setInterrupt(true);
                fuseExecuteStatus.setNull(false);
                fuseExecuteStatus.setDone(true);
                try {
                    Class<?> businessExceptionClass = Class.forName("com.digiwin.app.container.exceptions.DWBusinessException");
                    Class<?> throwableClass = t.getClass();
                    Class<?> throwableCauseClass = null;
                    if (t.getCause() != null) {
                        throwableCauseClass = t.getCause().getClass();
                    }
                    if (businessExceptionClass.equals(throwableClass) || businessExceptionClass.equals(throwableCauseClass)) {
                        throw new DWFuseBusinessException(t);
                    }
                    throw new DWFuseRuntimeException(t);
                }
                catch (ClassNotFoundException e) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    e.printStackTrace(printWriter);
                    String stackTrace = stringWriter.toString();
                    log.debug((Object)("[VoidConsumer] " + e.getMessage()));
                    log.debug((Object)("[VoidConsumer] " + stackTrace));
                    throw new DWFuseRuntimeException(t);
                }
            }
        };
        return voidConsumer;
    }
}

