/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.fuse.spring;

import com.digiwin.gateway.fuse.DWFuseExecutor;
import com.digiwin.gateway.fuse.DWReturnFuse;
import com.digiwin.gateway.fuse.annotation.FuseInbound;
import com.digiwin.gateway.fuse.annotation.FuseOutbound;
import com.digiwin.gateway.fuse.config.InboundConfig;
import com.digiwin.gateway.fuse.execute.DWFuseOption;
import com.digiwin.gateway.fuse.execute.DWFuseParameter;
import com.digiwin.gateway.fuse.execute.DWFuseReturnResponse;
import com.digiwin.gateway.fuse.spring.ConfigDecider;
import com.digiwin.gateway.fuse.spring.SpringAopFuse;
import com.digiwin.gateway.fuse.spring.pojo.FuseConfig;
import io.prometheus.client.CollectorRegistry;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Order(value=-2147483648)
@Component
public class FuseInboundAspect {
    private static Log log = LogFactory.getLog(FuseInboundAspect.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private FuseConfig fuseConfig;

    @Around(value="@annotation(com.digiwin.gateway.fuse.annotation.FuseInbound)")
    public Object inbound(ProceedingJoinPoint joinPoint) throws Throwable {
        log.debug((Object)"[Aspect] FuseInbound");
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        FuseInbound fuseInbound = method.getAnnotation(FuseInbound.class);
        FuseOutbound fuseOutbound = method.getAnnotation(FuseOutbound.class);
        if (fuseOutbound != null) {
            Object proceed = joinPoint.proceed();
            return proceed;
        }
        InboundConfig inboundConfig = ConfigDecider.get(this.fuseConfig, fuseInbound);
        DWFuseParameter fuseParameter = new DWFuseParameter();
        fuseParameter.set("joinPoint", (Object)joinPoint);
        SpringAopFuse springAopFuse = new SpringAopFuse();
        DWFuseReturnResponse fuseReturnResponse = new DWFuseReturnResponse();
        CollectorRegistry collectorRegistry = null;
        try {
            collectorRegistry = (CollectorRegistry)this.applicationContext.getBean(CollectorRegistry.class);
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            String stackTrace = stringWriter.toString();
            log.debug((Object)("[Aspect] FuseInbound collectorRegistry: " + e.getMessage()));
            log.debug((Object)("[Aspect] FuseInbound collectorRegistry: " + stackTrace));
        }
        inboundConfig.setCollectorRegistry(collectorRegistry);
        Map<String, String> optionMap = this.fuseConfig.toOptionMap();
        DWFuseOption option = new DWFuseOption(optionMap);
        log.debug((Object)("[Aspect] FuseInbound option: " + String.valueOf(option)));
        fuseReturnResponse = DWFuseExecutor.execute((DWReturnFuse)springAopFuse, (DWFuseParameter)fuseParameter, (InboundConfig)inboundConfig, (DWFuseOption)option);
        Object result = fuseReturnResponse.getResponse();
        return result;
    }
}

