/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.fuse.spring;

import com.digiwin.gateway.fuse.DWFuseExecutor;
import com.digiwin.gateway.fuse.DWReturnFuse;
import com.digiwin.gateway.fuse.annotation.FuseInbound;
import com.digiwin.gateway.fuse.annotation.FuseOutbound;
import com.digiwin.gateway.fuse.config.InboundConfig;
import com.digiwin.gateway.fuse.config.OutboundConfig;
import com.digiwin.gateway.fuse.execute.DWFuseOption;
import com.digiwin.gateway.fuse.execute.DWFuseParameter;
import com.digiwin.gateway.fuse.execute.DWFuseReturnResponse;
import com.digiwin.gateway.fuse.spring.ConfigDecider;
import com.digiwin.gateway.fuse.spring.SpringAopFuse;
import com.digiwin.gateway.fuse.spring.pojo.FuseConfig;
import io.prometheus.client.CollectorRegistry;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Order(value=0x7FFFFFFF)
@Component
public class FuseOutboundAspect {
    private static Log log = LogFactory.getLog(FuseOutboundAspect.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private FuseConfig fuseConfig;

    @Around(value="@annotation(com.digiwin.gateway.fuse.annotation.FuseOutbound)")
    public Object outbound(ProceedingJoinPoint joinPoint) throws Throwable {
        log.debug((Object)"[Aspect] FuseOutbound");
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        CollectorRegistry collectorRegistry = null;
        try {
            collectorRegistry = (CollectorRegistry)this.applicationContext.getBean(CollectorRegistry.class);
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            String stackTrace = stringWriter.toString();
            log.debug((Object)("[Aspect] FuseOutbound collectorRegistry: " + e.getMessage()));
            log.debug((Object)("[Aspect] FuseOutbound collectorRegistry: " + stackTrace));
        }
        FuseInbound fuseInbound = method.getAnnotation(FuseInbound.class);
        InboundConfig inboundConfig = null;
        if (fuseInbound != null) {
            inboundConfig = ConfigDecider.get(this.fuseConfig, fuseInbound);
            inboundConfig.setCollectorRegistry(collectorRegistry);
        }
        FuseOutbound fuseOutbound = method.getAnnotation(FuseOutbound.class);
        OutboundConfig outboundConfig = ConfigDecider.get(this.fuseConfig, fuseOutbound);
        outboundConfig.setCollectorRegistry(collectorRegistry);
        DWFuseParameter fuseParameter = new DWFuseParameter();
        fuseParameter.set("joinPoint", (Object)joinPoint);
        SpringAopFuse springAopFuse = new SpringAopFuse();
        DWFuseReturnResponse fuseReturnResponse = new DWFuseReturnResponse();
        Map<String, String> optionMap = this.fuseConfig.toOptionMap();
        DWFuseOption option = new DWFuseOption(optionMap);
        if (fuseInbound == null || !inboundConfig.isEnable()) {
            option.setXRateLimitHeaderOn(false);
            log.debug((Object)"[Aspect] inbound is disable or none, forced close XRateLimitHeader");
        }
        log.debug((Object)("[Aspect] FuseOutbound option: " + String.valueOf(option)));
        fuseReturnResponse = DWFuseExecutor.execute((DWReturnFuse)springAopFuse, (DWFuseParameter)fuseParameter, (InboundConfig)inboundConfig, (OutboundConfig)outboundConfig, (DWFuseOption)option);
        Object result = fuseReturnResponse.getResponse();
        return result;
    }
}

