/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.StreamingHttpOutputMessage;
import org.springframework.http.client.AccessibleAbstractStreamingClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.LegacyHttpComponentsClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

final class LegacyHttpComponentsClientHttpRequest
extends AccessibleAbstractStreamingClientHttpRequest {
    private final HttpClient httpClient;
    private final HttpUriRequest httpRequest;
    private final HttpContext httpContext;

    LegacyHttpComponentsClientHttpRequest(HttpClient client, HttpUriRequest request, HttpContext context) {
        this.httpClient = client;
        this.httpRequest = request;
        this.httpContext = context;
    }

    public HttpMethod getMethod() {
        return HttpMethod.valueOf((String)this.httpRequest.getMethod());
    }

    public URI getURI() {
        return this.httpRequest.getURI();
    }

    HttpContext getHttpContext() {
        return this.httpContext;
    }

    @Override
    protected ClientHttpResponse executeInternal(HttpHeaders headers, StreamingHttpOutputMessage.Body body) throws IOException {
        LegacyHttpComponentsClientHttpRequest.addHeaders(this.httpRequest, headers);
        if (body != null && this.httpRequest instanceof HttpEntityEnclosingRequest) {
            BodyEntity requestEntity = new BodyEntity(headers, body);
            ((HttpEntityEnclosingRequest)this.httpRequest).setEntity((HttpEntity)requestEntity);
        }
        HttpResponse httpResponse = this.httpClient.execute(this.httpRequest, this.httpContext);
        return new LegacyHttpComponentsClientHttpResponse(httpResponse);
    }

    static void addHeaders(HttpUriRequest httpRequest, HttpHeaders headers) {
        headers.forEach((headerName, headerValues) -> {
            if ("Cookie".equalsIgnoreCase((String)headerName)) {
                String headerValue = StringUtils.collectionToDelimitedString((Collection)headerValues, (String)"; ");
                httpRequest.addHeader(headerName, headerValue);
            } else if (!"Content-Length".equalsIgnoreCase((String)headerName) && !"Transfer-Encoding".equalsIgnoreCase((String)headerName)) {
                for (String headerValue : headerValues) {
                    httpRequest.addHeader(headerName, headerValue);
                }
            }
        });
    }

    private static class BodyEntity
    implements HttpEntity {
        private final HttpHeaders headers;
        private final StreamingHttpOutputMessage.Body body;

        public BodyEntity(HttpHeaders headers, StreamingHttpOutputMessage.Body body) {
            this.headers = headers;
            this.body = body;
        }

        public long getContentLength() {
            return this.headers.getContentLength();
        }

        @Nullable
        public Header getContentType() {
            return new BasicHeader("Content-Type", this.headers.getFirst("Content-Type"));
        }

        public InputStream getContent() {
            throw new UnsupportedOperationException();
        }

        public void writeTo(OutputStream outStream) throws IOException {
            this.body.writeTo(outStream);
        }

        public boolean isRepeatable() {
            return this.body.repeatable();
        }

        public boolean isStreaming() {
            return false;
        }

        public void consumeContent() throws IOException {
        }

        @Nullable
        public Header getContentEncoding() {
            return new BasicHeader("Content-Encoding", this.headers.getFirst("Content-Encoding"));
        }

        public boolean isChunked() {
            return false;
        }
    }
}

