/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client;

import com.digiwin.http.client.DWAPIResponseRetryStrategy;
import com.digiwin.http.client.DWHttpRetryManager;
import com.digiwin.http.context.DWHttpContextUtils;
import com.digiwin.http.context.DWHttpRetryInfo;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;

public class DWDefaultAPIResponseRetryStrategy
implements DWAPIResponseRetryStrategy {
    private static final Log log = LogFactory.getLog(DWDefaultAPIResponseRetryStrategy.class);
    private DWHttpRetryManager retryManager;

    public DWDefaultAPIResponseRetryStrategy(DWHttpRetryManager retryManager) {
        Objects.requireNonNull(retryManager, "retryManager can not be null!");
        this.retryManager = retryManager;
    }

    private boolean beforeRetry(DWHttpRetryInfo retryInfo, int executionCount, HttpContext context) {
        boolean idempotent = retryInfo.isIdempotent();
        log.info((Object)("DWDefaultAPIResponseRetryStrategy api idempotent = " + idempotent));
        if (!idempotent) {
            log.info((Object)String.format("DWDefaultAPIResponseRetryStrategy.beforeRetry stop! The target service[%s] is not idempotent.", retryInfo.getTargetId()));
            return false;
        }
        String backoffType = "none";
        long backoffTime = 0L;
        if (retryInfo.getBackoff() != null) {
            backoffTime = retryInfo.getBackoff().calculate(executionCount, retryInfo.getPreviousBackoff());
            backoffType = retryInfo.getBackoff().getClass().getSimpleName();
        }
        HttpRequest request = DWHttpContextUtils.getRequest(context);
        log.info((Object)String.format("DWDefaultAPIResponseRetryStrategy.beforeRetry[exeCount=%s, <%s>backoff=%s, url=%s]", executionCount, backoffType, backoffTime, request.getRequestLine().getUri()));
        if (backoffTime > 0L) {
            try {
                Thread.sleep(backoffTime);
            }
            catch (InterruptedException e) {
                log.warn((Object)"DWDefaultAPIResponseRetryStrategy.beforeRetry backoff failed!", (Throwable)e);
            }
        }
        retryInfo.increaseExecutionCount();
        return true;
    }

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        DWHttpRetryInfo retryInfo = this.retryManager.getRetryInfo(context);
        if (retryInfo == null || !retryInfo.canRetry()) {
            return false;
        }
        int status = response.getStatusLine().getStatusCode();
        if (status == 200) {
            try {
                if (retryInfo.matchSuccessResponseBodyKeywords(response)) {
                    return this.beforeRetry(retryInfo, executionCount, context);
                }
            }
            catch (IOException e) {
                log.warn((Object)"DWDefaultAPIResponseRetryStrategy retryRequest failed!", (Throwable)e);
            }
        } else if (retryInfo.matchResponseStatusCode(response)) {
            return this.beforeRetry(retryInfo, executionCount, context);
        }
        return false;
    }

    public long getRetryInterval() {
        return 0L;
    }
}

