/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client;

import com.digiwin.http.client.DWHttpRetryManager;
import com.digiwin.http.client.config.DWHttpRetryDefinition;
import com.digiwin.http.context.DWHttpRetryInfo;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;

public class DWDefaultHttpRequestRetryHandler
implements HttpRequestRetryHandler {
    private Log log = LogFactory.getLog(DWDefaultHttpRequestRetryHandler.class);
    private final Set<Class<? extends IOException>> nonRetriableClasses = new HashSet<Class<? extends IOException>>();
    private DWHttpRetryManager retryManager;

    public DWDefaultHttpRequestRetryHandler() {
        this((DWHttpRetryManager)null);
    }

    public DWDefaultHttpRequestRetryHandler(DWHttpRetryManager retryManager) {
        this(Arrays.asList(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, SSLException.class));
        this.retryManager = retryManager;
    }

    private DWHttpRetryManager getRetryManager() {
        return this.retryManager == null ? DWHttpRetryManager.getInstance() : this.retryManager;
    }

    public DWDefaultHttpRequestRetryHandler(Collection<Class<? extends IOException>> clazzes) {
        for (Class<? extends IOException> clazz : clazzes) {
            this.nonRetriableClasses.add(clazz);
        }
    }

    private int markIfItIsNoHTTPResponseException(IOException exception, int executionCount, DWHttpRetryInfo retryInfo) {
        if (retryInfo.markIfItIsNoHTTPResponseException(exception)) {
            this.log.info((Object)String.format("DWDefaultHttpRequestRetryHandler.retryRequest NoHTTPResponseException encountered(count = %s)!", retryInfo.getNoHTTPResponseExceptionCount()));
            int count = retryInfo.getNoHTTPResponseExceptionCount();
            if (count % 5 == 0) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    this.log.warn((Object)"DWDefaultHttpRequestRetryHandler.markIfItIsNoHTTPResponseException sleep failed!", (Throwable)e);
                }
            }
            return executionCount - retryInfo.getNoHTTPResponseExceptionCount();
        }
        return executionCount;
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        DWHttpRetryInfo retryInfo = this.getRetryManager().getRetryInfo(exception, context);
        if (retryInfo == null) {
            return false;
        }
        if ((executionCount = this.markIfItIsNoHTTPResponseException(exception, executionCount, retryInfo)) > retryInfo.getRetries()) {
            return false;
        }
        if (exception instanceof NoHttpResponseException) {
            return true;
        }
        DWHttpRetryDefinition retryDefinition = retryInfo.getSourceRetryDefinition();
        Set<Class<? extends Exception>> excludeClasses = retryDefinition.getExcludeClasses();
        if (Objects.isNull(excludeClasses) || excludeClasses.isEmpty()) {
            if (this.nonRetriableClasses.contains(exception.getClass())) {
                return false;
            }
            for (Class<Exception> clazz : this.nonRetriableClasses) {
                if (!clazz.isInstance(exception)) continue;
                return false;
            }
        } else {
            if (excludeClasses.contains(exception.getClass())) {
                return false;
            }
            for (Class<Exception> clazz : excludeClasses) {
                if (!clazz.isInstance(exception)) continue;
                return false;
            }
        }
        boolean idempotent = retryInfo.isIdempotent();
        this.log.info((Object)("DWDefaultHttpRequestRetryHandler api idempotent = " + idempotent));
        if (!idempotent) {
            this.log.info((Object)String.format("DWDefaultHttpRequestRetryHandler.retryRequest stop! The target service[%s] is not idempotent.", retryInfo.getTargetId()));
            return false;
        }
        HttpClientContext httpClientContext = HttpClientContext.adapt((HttpContext)context);
        HttpRequest request = httpClientContext.getRequest();
        String backoffType = "none";
        long backoffTime = 0L;
        if (retryInfo.getBackoff() != null) {
            backoffTime = retryInfo.getBackoff().calculate(executionCount, retryInfo.getPreviousBackoff());
            backoffType = retryInfo.getBackoff().getClass().getSimpleName();
        }
        this.log.info((Object)String.format("DWDefaultHttpRequestRetryHandler.retryRequest[exeCount=%s, <%s>backoff=%s, url=%s]", executionCount, backoffType, backoffTime, request.getRequestLine().getUri()));
        if (backoffTime > 0L) {
            try {
                Thread.sleep(backoffTime);
            }
            catch (InterruptedException e) {
                this.log.warn((Object)"DWDefaultHttpRequestRetryHandler.retryRequest backoff failed!", (Throwable)e);
            }
        }
        retryInfo.increaseExecutionCount();
        return true;
    }
}

