/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client;

import com.digiwin.http.client.DWHTTPHostAppIdMapper;
import com.digiwin.http.client.DWHttpRetryBackoff;
import com.digiwin.http.client.DWHttpTargetEAIServiceInfo;
import com.digiwin.http.client.config.DWAppServiceRetryConfig;
import com.digiwin.http.client.config.DWHttpAPIInfoProvider;
import com.digiwin.http.client.config.DWHttpPathPredicateDefinition;
import com.digiwin.http.client.config.DWHttpRetryConfigProvider;
import com.digiwin.http.client.config.DWHttpRetryDefinition;
import com.digiwin.http.client.exception.DWHttpRetryIOException;
import com.digiwin.http.client.utils.DWHttpRetryPredicates;
import com.digiwin.http.context.DWHttpContextUtils;
import com.digiwin.http.context.DWHttpRetryInfo;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.protocol.HttpContext;

public class DWHttpRetryManager {
    private static Log log = LogFactory.getLog(DWHttpRetryManager.class);
    private static final String APP_ID_ALL_EAI = "eai:*";
    public static String DEFAULT_CONFIG_APP_ID = "default";
    private static DWHttpRetryManager instance;
    private DWAppServiceRetryConfig defaultAppRetryConfig;
    private DWHttpRetryConfigProvider retryConfigProvider;
    private DWHttpAPIInfoProvider apiInfoProvider;
    private DWHTTPHostAppIdMapper hostAppIdMapper;

    public static DWHttpRetryManager getInstance() {
        if (instance == null) {
            throw new RuntimeException("DWHttpRetryManager instance is not ready, please contact DAP for this issue.");
        }
        return instance;
    }

    public static void setDWHttpRetryManager(DWHttpRetryManager httpRetryManager) {
        instance = httpRetryManager;
    }

    public DWHttpRetryManager(DWHttpRetryConfigProvider retryConfigProvider, DWHttpAPIInfoProvider apiInfoProvider, DWHttpRetryBackoff defaultBackoff, DWHTTPHostAppIdMapper hostAppIdMapper) {
        Objects.requireNonNull(retryConfigProvider, "retryConfigProvider can not be null!");
        Objects.requireNonNull(apiInfoProvider, "apiInfoProvider can not be null!");
        Objects.requireNonNull(defaultBackoff, "defaultBackoff can not be null!");
        this.retryConfigProvider = retryConfigProvider;
        this.apiInfoProvider = apiInfoProvider;
        this.hostAppIdMapper = hostAppIdMapper;
        this.initDefaultAppRetryConfig(defaultBackoff);
    }

    private void initDefaultAppRetryConfig(DWHttpRetryBackoff defaultBackoff) {
        DWAppServiceRetryConfig defaultConfig = this.retryConfigProvider.getConfig(DEFAULT_CONFIG_APP_ID);
        if (defaultConfig == null) {
            defaultConfig = new DWAppServiceRetryConfig(DEFAULT_CONFIG_APP_ID);
            defaultConfig.setEnable(true);
            DWHttpPathPredicateDefinition defaultPathPredicateDefinition = new DWHttpPathPredicateDefinition("/**");
            defaultConfig.addPathDefinition(defaultPathPredicateDefinition);
            defaultPathPredicateDefinition.setEnable(true);
            DWHttpRetryDefinition defaultRetryDefinition = new DWHttpRetryDefinition();
            defaultPathPredicateDefinition.setRetry(defaultRetryDefinition);
            defaultRetryDefinition.setRetries(3);
            defaultRetryDefinition.setStatusArray("502", "503");
            defaultRetryDefinition.setMethodArray("GET", "POST", "PUT", "DELETE");
            defaultRetryDefinition.setBackoff(defaultBackoff);
        }
        this.defaultAppRetryConfig = defaultConfig;
        this.defaultAppRetryConfig.setEnable(false);
    }

    public DWHttpRetryInfo getRetryInfo(IOException exception, HttpContext context) {
        if (exception instanceof DWHttpRetryIOException) {
            DWHttpRetryIOException retryEx = (DWHttpRetryIOException)exception;
            return retryEx.getRetryInfo();
        }
        return this.getRetryInfo(context);
    }

    private boolean isEAIService(HttpContext context) {
        Boolean isEaiService = DWHttpContextUtils.isEAIService(context);
        if (isEaiService == null) {
            DWHttpTargetEAIServiceInfo targetEAIServiceInfo = null;
            HttpRequest httpRequest = DWHttpContextUtils.getRequest(context);
            Header header = httpRequest.getFirstHeader("digi-service");
            if (header != null) {
                String headerValue = header.getValue();
                try {
                    Map digiServiceMap = (Map)new Gson().fromJson(headerValue, Map.class);
                    String productName = (String)digiServiceMap.get("prod");
                    String serviceName = (String)digiServiceMap.get("name");
                    String tenantId = (String)digiServiceMap.get("tenant_id");
                    targetEAIServiceInfo = new DWHttpTargetEAIServiceInfo(productName, serviceName, tenantId);
                    log.debug((Object)("DWHttpRetryManager.isEAIService, found eai digi-service header, target service = " + targetEAIServiceInfo));
                }
                catch (Exception e) {
                    log.error((Object)String.format("DWHttpRetryManager.isEAIService, parse eai digi-service header(%s) failed!", headerValue), (Throwable)e);
                }
            }
            isEaiService = DWHttpContextUtils.setEAIServiceInfo(context, targetEAIServiceInfo);
        }
        return isEaiService;
    }

    private String getAppId(HttpContext context) {
        String contextAppId;
        boolean isEAIService = this.isEAIService(context);
        log.debug((Object)("DWHttpRetryManager.getAppId, isEAIService = " + isEAIService));
        if (isEAIService) {
            contextAppId = APP_ID_ALL_EAI;
        } else {
            String contextHost;
            contextAppId = DWHttpContextUtils.getAppId(context);
            log.debug((Object)("DWHttpRetryManager.getAppId, first look contextAppId = " + contextAppId));
            if (contextAppId == null && (contextHost = DWHttpContextUtils.getHost(context)) != null) {
                log.debug((Object)("DWHttpRetryManager.getAppId, host = " + contextHost));
                contextAppId = this.hostAppIdMapper.getFirstAppId(contextHost);
                if (contextAppId != null) {
                    DWHttpContextUtils.setAppId(context, contextAppId);
                    log.debug((Object)("DWHttpRetryManager.getAppId, host mapping appId = " + contextAppId));
                } else {
                    contextAppId = contextHost;
                }
            }
        }
        log.debug((Object)("DWHttpRetryManager.getAppId, final contextAppId = " + contextAppId));
        return contextAppId;
    }

    public DWHttpRetryInfo getRetryInfo(HttpContext context) {
        Boolean hasRetry = DWHttpContextUtils.hasRetry(context);
        if (hasRetry == null) {
            DWHttpRetryInfo retryInfo;
            log.debug((Object)"DWHttpRetryManager > start searching retry setting...");
            String contextAppId = this.getAppId(context);
            DWAppServiceRetryConfig appRetryConfig = this.retryConfigProvider.getConfig(contextAppId);
            DWHttpPathPredicateDefinition matchedDefinition = null;
            if (appRetryConfig != null && appRetryConfig.isEnable()) {
                matchedDefinition = this.getMappingPathPredicateDefinition(context, appRetryConfig);
                log.debug((Object)"DWHttpRetryManager > found app retry config.");
            }
            if (matchedDefinition == null) {
                if (this.defaultAppRetryConfig.isEnable()) {
                    matchedDefinition = this.getMappingPathPredicateDefinition(context, this.defaultAppRetryConfig);
                    log.debug((Object)"DWHttpRetryManager > use [default] app retry config for further searching...");
                }
                if (matchedDefinition == null) {
                    retryInfo = null;
                    log.debug((Object)"DWHttpRetryManager > no matching path retry definition!");
                } else {
                    String targetId;
                    if (DWHttpContextUtils.isEAIService(context).booleanValue()) {
                        DWHttpTargetEAIServiceInfo eaiServiceInfo = DWHttpContextUtils.getEAIServiceInfo(context);
                        targetId = String.format("<%s>%s", eaiServiceInfo.getProductName(), eaiServiceInfo.getServiceName());
                    } else {
                        targetId = String.format("<%s>%s", contextAppId, DWHttpContextUtils.getServicePath(context));
                    }
                    retryInfo = new DWHttpRetryInfo(matchedDefinition, targetId, () -> this.apiInfoProvider.handleAsIdempotent(context));
                    log.debug((Object)String.format("DWHttpRetryManager > found [default] path retry definition(path=%s).", matchedDefinition.getPath()));
                }
            } else {
                retryInfo = new DWHttpRetryInfo(matchedDefinition);
                log.debug((Object)String.format("DWHttpRetryManager > found user defined path retry definition(path=%s).", matchedDefinition.getPath()));
            }
            DWHttpContextUtils.setRetryInfo(context, retryInfo);
        }
        return DWHttpContextUtils.getRetryInfo(context);
    }

    private DWHttpPathPredicateDefinition getMappingPathPredicateDefinition(HttpContext context, DWAppServiceRetryConfig appRetryConfig) {
        List definitions = appRetryConfig.getPaths().stream().filter(DWHttpPathPredicateDefinition::isEnable).collect(Collectors.toList());
        BiPredicate<DWHttpPathPredicateDefinition, HttpContext> predicate = DWHttpRetryPredicates.getDefaultRetryPredicate();
        return definitions.stream().filter(p -> predicate.test((DWHttpPathPredicateDefinition)p, context)).findFirst().orElse(null);
    }
}

