/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client.utils;

import com.digiwin.http.client.config.DWHttpPathPredicateDefinition;
import com.digiwin.http.client.utils.DWPathPatternHelper;
import com.digiwin.http.context.DWHttpContextUtils;
import java.util.Arrays;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.http.HttpRequest;
import org.apache.http.RequestLine;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;

public final class DWHttpRetryPredicates {
    public static BiPredicate<DWHttpPathPredicateDefinition, HttpContext> getDefaultRetryPredicate() {
        BiPredicate<DWHttpPathPredicateDefinition, HttpContext> predicate = DWHttpRetryPredicates::matchPath;
        predicate = predicate.and(DWHttpRetryPredicates::matchHttpMethod);
        return predicate;
    }

    public static boolean matchPath(DWHttpPathPredicateDefinition pathDefinition, HttpContext context) {
        String lookupPath;
        HttpRequest request = DWHttpContextUtils.getRequest(context);
        if (request == null) {
            return false;
        }
        if (DWHttpContextUtils.isEAIService(context).booleanValue()) {
            lookupPath = String.format("eai:%s", DWHttpContextUtils.getEAIServiceInfo(context).getServiceName());
        } else if (request instanceof HttpUriRequest) {
            lookupPath = ((HttpUriRequest)request).getURI().getPath();
        } else {
            RequestLine requestLine = request.getRequestLine();
            int doubleSlashPos = requestLine.getUri().indexOf("//");
            lookupPath = requestLine.getUri().substring(doubleSlashPos + 2);
            if ((lookupPath = lookupPath.substring(lookupPath.indexOf("/"))).contains("?")) {
                lookupPath = lookupPath.substring(0, lookupPath.indexOf("?"));
            }
        }
        String pattern = pathDefinition.getPath().trim();
        String match = DWPathPatternHelper.getMatchingPattern(pattern, lookupPath);
        return match != null;
    }

    public static boolean matchHttpMethod(DWHttpPathPredicateDefinition pathDefinition, HttpContext context) {
        if (pathDefinition == null || pathDefinition.getRetry() == null || context == null) {
            return false;
        }
        HttpRequest request = DWHttpContextUtils.getRequest(context);
        if (request == null) {
            return false;
        }
        String method = request.getRequestLine().getMethod();
        return DWHttpRetryPredicates.matchHttpMethod(pathDefinition.getRetry().getMethods(), method);
    }

    public static boolean matchHttpMethod(String predicateMethods, String method) {
        if (predicateMethods == null || method == null) {
            return false;
        }
        String[] parts = predicateMethods.split(",");
        boolean match = Arrays.stream(parts).map(String::trim).anyMatch(predicateMethod -> predicateMethod.equalsIgnoreCase(method));
        return match;
    }

    public static boolean matchResponseStatus(String predicateStatusCodes, int statusCode) {
        if (predicateStatusCodes == null) {
            return false;
        }
        String[] parts = predicateStatusCodes.split(",");
        Set partSet = Arrays.stream(parts).map(String::trim).collect(Collectors.toSet());
        boolean match = Arrays.stream(parts).map(String::trim).anyMatch(predicateStatusCode -> predicateStatusCode.equals(String.valueOf(statusCode)));
        return match;
    }
}

