/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.context;

import com.digiwin.http.client.DWAppIdProvider;
import com.digiwin.http.client.DWHttpTargetEAIServiceInfo;
import com.digiwin.http.context.DWHttpRetryInfo;
import java.lang.reflect.Proxy;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;

public class DWHttpContextUtils {
    public static final String SCHEME_DIGIWIN_APP = "dwapp";
    private static final String ATTRIBUTE_IS_DECENTRALIZED = "dwhttp.isdecentralized";
    private static final String ATTRIBUTE_IS_EAI_SERVICE = "dwhttp.iseaiservice";
    private static final String ATTRIBUTE_IS_EAI_SERVICE_INFO = "dwhttp.eaiservice.info";
    private static final String ATTRIBUTE_APPID = "dwhttp.appid";
    private static final String ATTRIBUTE_HOST = "dwhttp.host";
    private static final String ATTRIBUTE_SERVICE_PATH = "dwhttp.service.path";
    private static final String ATTRIBUTE_HAS_RETRY = "dwhttp.hasretry";
    private static final String ATTRIBUTE_RETRY_INFO = "dwhttp.retryinfo";
    private static final String ATTRIBUTE_IS_IDEMPOTENCE = "dwhttp.isidempotence";

    public static HttpRequest getRequest(HttpContext context) {
        return (HttpRequest)context.getAttribute("http.request");
    }

    public static void setAppId(HttpContext context, String appId) {
        context.setAttribute(ATTRIBUTE_APPID, (Object)appId);
    }

    private static void setHost(HttpContext context, String host) {
        context.setAttribute(ATTRIBUTE_HOST, (Object)host);
    }

    private static void setServicePath(HttpContext context, String servicePath) {
        context.setAttribute(ATTRIBUTE_SERVICE_PATH, (Object)servicePath);
    }

    public static String getServicePath(HttpContext context) {
        return (String)context.getAttribute(ATTRIBUTE_SERVICE_PATH);
    }

    public static String getHost(HttpContext context) {
        String appId = (String)context.getAttribute(ATTRIBUTE_APPID);
        String host = (String)context.getAttribute(ATTRIBUTE_HOST);
        if (appId == null && host == null) {
            DWHttpContextUtils.getAppId(context);
            host = DWHttpContextUtils.getHost(context);
        }
        return host;
    }

    public static Boolean isDecentralized(HttpContext context) {
        return (Boolean)context.getAttribute(ATTRIBUTE_IS_DECENTRALIZED);
    }

    public static Boolean isEAIService(HttpContext context) {
        return (Boolean)context.getAttribute(ATTRIBUTE_IS_EAI_SERVICE);
    }

    public static DWHttpTargetEAIServiceInfo getEAIServiceInfo(HttpContext context) {
        return (DWHttpTargetEAIServiceInfo)context.getAttribute(ATTRIBUTE_IS_EAI_SERVICE_INFO);
    }

    public static boolean setEAIServiceInfo(HttpContext context, DWHttpTargetEAIServiceInfo eaiServiceInfo) {
        boolean isEAIService = eaiServiceInfo != null && eaiServiceInfo.getServiceName() != null;
        context.setAttribute(ATTRIBUTE_IS_EAI_SERVICE, (Object)isEAIService);
        context.setAttribute(ATTRIBUTE_IS_EAI_SERVICE_INFO, (Object)(isEAIService ? eaiServiceInfo : null));
        return isEAIService;
    }

    public static String getAppId(HttpContext context) {
        String appId = (String)context.getAttribute(ATTRIBUTE_APPID);
        String host = (String)context.getAttribute(ATTRIBUTE_HOST);
        String servicePath = null;
        if (appId == null && host == null) {
            Header dwappHeader;
            DWAppIdProvider appIdProvider = null;
            HttpRequest request = DWHttpContextUtils.getRequest(context);
            if (request instanceof HttpRequestWrapper) {
                request = ((HttpRequestWrapper)request).getOriginal();
            }
            if (request != null && Proxy.isProxyClass(request.getClass()) && (dwappHeader = request.getFirstHeader(SCHEME_DIGIWIN_APP)) instanceof DWAppIdProvider) {
                appIdProvider = (DWAppIdProvider)dwappHeader;
            }
            if (appIdProvider != null) {
                appId = appIdProvider.getAppId();
            }
            DWHttpContextUtils.setAppId(context, appId);
            host = null;
            if (request instanceof HttpUriRequest) {
                URI uri = ((HttpUriRequest)request).getURI();
                host = uri.getHost();
                servicePath = uri.getPath();
            }
            DWHttpContextUtils.setHost(context, host);
            DWHttpContextUtils.setServicePath(context, servicePath);
        }
        return appId;
    }

    public static void setIdempotence(HttpContext context, boolean idempotence) {
        context.setAttribute(ATTRIBUTE_IS_IDEMPOTENCE, (Object)idempotence);
    }

    public static Boolean isIdempotence(HttpContext context) {
        return (Boolean)context.getAttribute(ATTRIBUTE_IS_IDEMPOTENCE);
    }

    private static void setRetry(HttpContext context, boolean retry) {
        context.setAttribute(ATTRIBUTE_HAS_RETRY, (Object)retry);
    }

    public static Boolean hasRetry(HttpContext context) {
        return (Boolean)context.getAttribute(ATTRIBUTE_HAS_RETRY);
    }

    public static boolean setRetryInfo(HttpContext context, DWHttpRetryInfo retryInfo) {
        boolean hasRetry = retryInfo != null;
        DWHttpContextUtils.setRetry(context, hasRetry);
        context.setAttribute(ATTRIBUTE_RETRY_INFO, (Object)retryInfo);
        return hasRetry;
    }

    public static DWHttpRetryInfo getRetryInfo(HttpContext context) {
        return (DWHttpRetryInfo)context.getAttribute(ATTRIBUTE_RETRY_INFO);
    }
}

