/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client;

import com.digiwin.http.client.DWHTTPHostAppIdMapper;
import com.digiwin.http.client.DWHttpRetryArithmeticSequenceBackoff;
import com.digiwin.http.client.DWHttpRetryProperties;
import com.digiwin.http.client.DWHttpTargetEAIServiceInfo;
import com.digiwin.http.client.config.DWAppServiceRetryConfig;
import com.digiwin.http.client.config.DWHttpAPIInfoProvider;
import com.digiwin.http.client.config.DWHttpPathPredicateDefinition;
import com.digiwin.http.client.config.DWHttpRetryConfigProvider;
import com.digiwin.http.client.config.DWHttpRetryDefinition;
import com.digiwin.http.client.exception.DWHttpRetryIOException;
import com.digiwin.http.client.utils.DWHttpRetryPredicates;
import com.digiwin.http.context.DWHttpContextUtils;
import com.digiwin.http.context.DWHttpRetryInfo;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.protocol.HttpContext;

public class DWHttpRetryManager {
    private static Log log = LogFactory.getLog(DWHttpRetryManager.class);
    private static final String APP_ID_ALL_EAI = "eai:*";
    public static String GENERAL_API_DEFAULT_CONFIG_APP_ID = "general-api:default";
    public static String EAI_API_DEFAULT_CONFIG_APP_ID = "eai-api:default";
    private static DWHttpRetryManager instance;
    private DWHttpRetryProperties retryProperties = new DWHttpRetryProperties();
    private DWAppServiceRetryConfig generalAPIDefaultAppRetryConfig;
    private DWAppServiceRetryConfig eaiAPIDefaultAppRetryConfig;
    private DWHttpRetryConfigProvider retryConfigProvider;
    private DWHttpAPIInfoProvider apiInfoProvider;
    private DWHTTPHostAppIdMapper hostAppIdMapper;

    public static DWHttpRetryManager getInstance() {
        if (instance == null) {
            throw new RuntimeException("DWHttpRetryManager instance is not ready, please contact DAP for this issue.");
        }
        return instance;
    }

    public static void setDWHttpRetryManager(DWHttpRetryManager httpRetryManager) {
        instance = httpRetryManager;
    }

    public DWHttpRetryManager(DWHttpRetryConfigProvider retryConfigProvider, DWHttpAPIInfoProvider apiInfoProvider, DWHTTPHostAppIdMapper hostAppIdMapper, DWHttpRetryProperties retryProperties) {
        DWAppServiceRetryConfig userDefinedGeneralAPIDefaultConfig;
        Objects.requireNonNull(retryConfigProvider, "retryConfigProvider can not be null!");
        Objects.requireNonNull(apiInfoProvider, "apiInfoProvider can not be null!");
        Objects.requireNonNull(hostAppIdMapper, "hostAppIdMapper can not be null!");
        this.retryConfigProvider = retryConfigProvider;
        this.apiInfoProvider = apiInfoProvider;
        this.hostAppIdMapper = hostAppIdMapper;
        if (retryProperties != null) {
            this.retryProperties = retryProperties;
        }
        this.generalAPIDefaultAppRetryConfig = (userDefinedGeneralAPIDefaultConfig = this.retryConfigProvider.getConfig(GENERAL_API_DEFAULT_CONFIG_APP_ID)) == null ? this.createCodeLevelGeneralAPIDefaultRetryConfig(retryProperties) : userDefinedGeneralAPIDefaultConfig;
        DWAppServiceRetryConfig userDefinedEAIAPIDefaultConfig = this.retryConfigProvider.getConfig(EAI_API_DEFAULT_CONFIG_APP_ID);
        this.eaiAPIDefaultAppRetryConfig = userDefinedEAIAPIDefaultConfig == null ? this.createCodeLevelEAIAPIDefaultRetryConfig(retryProperties) : userDefinedEAIAPIDefaultConfig;
    }

    private DWAppServiceRetryConfig createCodeLevelGeneralAPIDefaultRetryConfig(DWHttpRetryProperties retryProperties) {
        if (retryProperties == null || !retryProperties.isGeneralAPIDefaultConfigEnabled()) {
            return null;
        }
        DWHttpRetryArithmeticSequenceBackoff defaultBackoff = new DWHttpRetryArithmeticSequenceBackoff(2000L, 120000L, 2000);
        DWAppServiceRetryConfig codeLevelGeneralDefaultConfig = new DWAppServiceRetryConfig(GENERAL_API_DEFAULT_CONFIG_APP_ID);
        codeLevelGeneralDefaultConfig.setEnable(true);
        DWHttpPathPredicateDefinition defaultGeneralAPIPathPredicateDefinition = new DWHttpPathPredicateDefinition("/**");
        codeLevelGeneralDefaultConfig.addPathDefinition(defaultGeneralAPIPathPredicateDefinition);
        defaultGeneralAPIPathPredicateDefinition.setEnable(true);
        DWHttpRetryDefinition defaultGeneralAPIRetryDefinition = new DWHttpRetryDefinition();
        defaultGeneralAPIPathPredicateDefinition.setRetry(defaultGeneralAPIRetryDefinition);
        defaultGeneralAPIRetryDefinition.setRetries(3);
        defaultGeneralAPIRetryDefinition.setStatusArray("502", "503");
        defaultGeneralAPIRetryDefinition.setMethodArray("GET", "POST", "PUT", "DELETE");
        defaultGeneralAPIRetryDefinition.setBackoff(defaultBackoff);
        return codeLevelGeneralDefaultConfig;
    }

    private DWAppServiceRetryConfig createCodeLevelEAIAPIDefaultRetryConfig(DWHttpRetryProperties retryProperties) {
        if (retryProperties == null || !retryProperties.isEaiAPIDefaultConfigEnabled()) {
            return null;
        }
        DWHttpRetryArithmeticSequenceBackoff defaultBackoff = new DWHttpRetryArithmeticSequenceBackoff(2000L, 120000L, 2000);
        DWAppServiceRetryConfig codeLevelEAIAPIDefaultConfig = new DWAppServiceRetryConfig(EAI_API_DEFAULT_CONFIG_APP_ID);
        codeLevelEAIAPIDefaultConfig.setEnable(true);
        DWHttpPathPredicateDefinition defaultGeneralAPIPathPredicateDefinition = new DWHttpPathPredicateDefinition(APP_ID_ALL_EAI);
        codeLevelEAIAPIDefaultConfig.addPathDefinition(defaultGeneralAPIPathPredicateDefinition);
        defaultGeneralAPIPathPredicateDefinition.setEnable(true);
        DWHttpRetryDefinition defaultGeneralAPIRetryDefinition = new DWHttpRetryDefinition();
        defaultGeneralAPIPathPredicateDefinition.setRetry(defaultGeneralAPIRetryDefinition);
        defaultGeneralAPIRetryDefinition.setRetries(3);
        defaultGeneralAPIRetryDefinition.setStatusArray("502", "503");
        defaultGeneralAPIRetryDefinition.setMethodArray("GET", "POST", "PUT", "DELETE");
        defaultGeneralAPIRetryDefinition.setBackoff(defaultBackoff);
        return codeLevelEAIAPIDefaultConfig;
    }

    public DWHttpRetryInfo getRetryInfo(IOException exception, HttpContext context) {
        if (exception instanceof DWHttpRetryIOException) {
            DWHttpRetryIOException retryEx = (DWHttpRetryIOException)exception;
            return retryEx.getRetryInfo();
        }
        return this.getRetryInfo(context);
    }

    private boolean isEAIService(HttpContext context) {
        Boolean isEaiService = DWHttpContextUtils.isEAIService(context);
        if (isEaiService == null) {
            DWHttpTargetEAIServiceInfo targetEAIServiceInfo = null;
            HttpRequest httpRequest = DWHttpContextUtils.getRequest(context);
            Header header = httpRequest.getFirstHeader("digi-service");
            if (header != null) {
                String headerValue = header.getValue();
                try {
                    Map digiServiceMap = (Map)new Gson().fromJson(headerValue, Map.class);
                    String productName = (String)digiServiceMap.get("prod");
                    String serviceName = (String)digiServiceMap.get("name");
                    String tenantId = (String)digiServiceMap.get("tenant_id");
                    targetEAIServiceInfo = new DWHttpTargetEAIServiceInfo(productName, serviceName, tenantId);
                    log.debug((Object)("DWHttpRetryManager.isEAIService, found eai digi-service header, target service = " + targetEAIServiceInfo));
                }
                catch (Exception e) {
                    log.error((Object)String.format("DWHttpRetryManager.isEAIService, parse eai digi-service header(%s) failed!", headerValue), (Throwable)e);
                }
            }
            isEaiService = DWHttpContextUtils.setEAIServiceInfo(context, targetEAIServiceInfo);
        }
        return isEaiService;
    }

    private String getAppId(HttpContext context) {
        String contextAppId;
        boolean isEAIService = this.isEAIService(context);
        log.debug((Object)("DWHttpRetryManager.getAppId, isEAIService = " + isEAIService));
        if (isEAIService) {
            contextAppId = APP_ID_ALL_EAI;
        } else {
            String contextHost;
            contextAppId = DWHttpContextUtils.getAppId(context);
            log.debug((Object)("DWHttpRetryManager.getAppId, first look contextAppId = " + contextAppId));
            if (contextAppId == null && (contextHost = DWHttpContextUtils.getHost(context)) != null) {
                log.debug((Object)("DWHttpRetryManager.getAppId, host = " + contextHost));
                contextAppId = this.hostAppIdMapper.getFirstAppId(contextHost);
                if (contextAppId != null) {
                    DWHttpContextUtils.setAppId(context, contextAppId);
                    log.debug((Object)("DWHttpRetryManager.getAppId, host mapping appId = " + contextAppId));
                } else {
                    contextAppId = contextHost;
                }
            }
        }
        log.debug((Object)("DWHttpRetryManager.getAppId, final contextAppId = " + contextAppId));
        return contextAppId;
    }

    private DWAppServiceRetryConfig getDefaultConfig(boolean isEAIService) {
        if (isEAIService) {
            return this.eaiAPIDefaultAppRetryConfig;
        }
        return this.generalAPIDefaultAppRetryConfig;
    }

    public DWHttpRetryInfo getRetryInfo(HttpContext context) {
        Boolean hasRetry = DWHttpContextUtils.hasRetry(context);
        if (hasRetry == null) {
            String targetInfo;
            boolean foundAppConfig = false;
            boolean isUserConfig = false;
            boolean checkingIdempotence = true;
            DWHttpRetryInfo retryInfo = null;
            log.debug((Object)"DWHttpRetryManager > start searching retry setting...");
            String contextAppId = this.getAppId(context);
            boolean isEAIService = DWHttpContextUtils.isEAIService(context);
            DWAppServiceRetryConfig appRetryConfig = this.retryConfigProvider.getConfig(contextAppId);
            DWHttpPathPredicateDefinition matchedDefinition = null;
            if (appRetryConfig != null && appRetryConfig.isEnable()) {
                foundAppConfig = true;
                matchedDefinition = this.getMappingPathPredicateDefinition(context, appRetryConfig);
            }
            if (matchedDefinition == null) {
                DWAppServiceRetryConfig defaultAppRetryConfig = this.getDefaultConfig(isEAIService);
                if (defaultAppRetryConfig != null && defaultAppRetryConfig.isEnable()) {
                    foundAppConfig = true;
                    matchedDefinition = this.getMappingPathPredicateDefinition(context, defaultAppRetryConfig);
                }
            } else {
                isUserConfig = true;
                checkingIdempotence = this.retryProperties.isGeneralAPIUserConfigCheckIdempotence();
            }
            if (isEAIService) {
                DWHttpTargetEAIServiceInfo eaiServiceInfo = DWHttpContextUtils.getEAIServiceInfo(context);
                targetInfo = String.format("<productName=%s>%s", eaiServiceInfo.getProductName(), eaiServiceInfo.getServiceName());
            } else {
                HttpRequest request = DWHttpContextUtils.getRequest(context);
                String method = request.getRequestLine().getMethod();
                if ("get".equalsIgnoreCase(method)) {
                    log.debug((Object)"DWHttpRetryManager > get method, no need to check API idempotence.");
                    checkingIdempotence = false;
                }
                targetInfo = String.format("<host/domain=%s, appId=%s, httpMethod=%s>%s", DWHttpContextUtils.getHost(context), contextAppId, method, DWHttpContextUtils.getServicePath(context));
            }
            if (matchedDefinition == null) {
                log.debug((Object)String.format(foundAppConfig ? "DWHttpRetryManager > no matching path retry definition for target API(%s)!" : "DWHttpRetryManager > there is no retry setting for target API(%s)!", targetInfo));
            } else {
                if (isUserConfig) {
                    log.debug((Object)String.format("DWHttpRetryManager > found user defined retry definition(appid=%s, path=%s, hasRetryObject=%s) for target API(%s), checkIdempotence=%s", contextAppId, matchedDefinition.getPath(), matchedDefinition.getRetry() != null, targetInfo, checkingIdempotence));
                } else {
                    log.debug((Object)String.format("DWHttpRetryManager > found [%s path=%s, hasRetryObject=%s] retry definition for target API(%s), checkIdempotence=%s", isEAIService ? EAI_API_DEFAULT_CONFIG_APP_ID : GENERAL_API_DEFAULT_CONFIG_APP_ID, matchedDefinition.getPath(), matchedDefinition.getRetry() != null, targetInfo, checkingIdempotence));
                }
                retryInfo = new DWHttpRetryInfo(matchedDefinition, targetInfo, checkingIdempotence ? () -> this.apiInfoProvider.handleAsIdempotent(context) : null);
            }
            DWHttpContextUtils.setRetryInfo(context, retryInfo);
            return retryInfo;
        }
        return DWHttpContextUtils.getRetryInfo(context);
    }

    private DWHttpPathPredicateDefinition getMappingPathPredicateDefinition(HttpContext context, DWAppServiceRetryConfig appRetryConfig) {
        List definitions = appRetryConfig.getPaths().stream().filter(DWHttpPathPredicateDefinition::isEnable).collect(Collectors.toList());
        boolean userDefinedConfig = appRetryConfig != this.generalAPIDefaultAppRetryConfig;
        BiPredicate<DWHttpPathPredicateDefinition, HttpContext> predicate = userDefinedConfig && this.retryProperties.isGeneralAPIUserConfigCheckIdempotence() ? DWHttpRetryPredicates::matchPath : DWHttpRetryPredicates.getDefaultRetryPredicate();
        return definitions.stream().filter(p -> predicate.test((DWHttpPathPredicateDefinition)p, context)).findFirst().orElse(null);
    }
}

