/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client.exception;

import com.digiwin.app.container.exceptions.DWInvocationException;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.http.client.entity.DWHttpFailedResponseEntity;
import com.google.gson.Gson;
import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public class DWHttpFailedException
extends DWInvocationException {
    private static Log log = LogFactory.getLog(DWHttpFailedException.class);
    private HttpResponse response;

    public DWHttpFailedException(HttpResponse response) {
        this.response = response;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public <T> T getEntity(Type entityTypeOfT) {
        Object entity = null;
        Gson gson = DWGsonProvider.getGson();
        try {
            String bodyString = EntityUtils.toString((HttpEntity)this.response.getEntity(), (String)"UTF-8");
            if (entityTypeOfT == String.class) {
                return (T)bodyString;
            }
            entity = gson.fromJson(bodyString, entityTypeOfT);
        }
        catch (IOException e) {
            throw new RuntimeException("DWHttpFailedException getEntity failed!", e);
        }
        return (T)entity;
    }

    public <T> T getEntity(Class<T> entityType) {
        return this.getEntity((Type)entityType);
    }

    public DWHttpFailedResponseEntity getDapApiFailedEntity() {
        return this.getEntity(DWHttpFailedResponseEntity.class);
    }
}

