/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client.utils;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.service.DWServiceContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class DWRequestHeaderUtils {
    public static final String HEADER_DAP_API_TOKEN = "token";
    public static final String HEADER_DAP_ORGINAL_IAM_URL_KEY = "origin-iam-url-key";
    public static final String PROPERTY_IAM_AP_TOKEN = "iamApToken";
    public static final String PROPERTY_SERVER_HTTP_TOKEN_MODE = "serverHttpTokenmode";
    public static final String SERVER_HTTP_TOKEN_MODE_IAM = "IAM";
    public static final String HEADER_IAM_API_USER_TOKEN = "digi-middleware-auth-user";
    public static final String HEADER_IAM_API_APP_TOKEN = "digi-middleware-auth-app";

    public static Map<String, String> getDapApiRequiredHeaders() {
        HashMap<String, String> requiredHeaders = new HashMap<String, String>();
        String token = DWServiceContext.getContext().getToken();
        if (token != null && !token.isEmpty()) {
            requiredHeaders.put(HEADER_DAP_API_TOKEN, token);
        }
        return requiredHeaders;
    }

    public static Map<String, String> getIamApiRequiredHeaders() {
        String token;
        HashMap<String, String> requiredHeaders = new HashMap<String, String>();
        String originIamUrlKey = DWServiceContext.getContext().getRequestHeader().getOrDefault(HEADER_DAP_ORGINAL_IAM_URL_KEY, "");
        String iamApToken = "";
        if (StringUtils.isNotBlank((CharSequence)originIamUrlKey)) {
            iamApToken = DWServiceContext.getContext().getRequestHeader().getOrDefault(HEADER_IAM_API_APP_TOKEN, "");
        } else {
            iamApToken = DWApplicationConfigUtils.getProperty((String)PROPERTY_IAM_AP_TOKEN, (String)"");
            if (iamApToken.isEmpty()) {
                iamApToken = DWServiceContext.getContext().getRequestHeader().getOrDefault(HEADER_IAM_API_APP_TOKEN, "");
            }
        }
        requiredHeaders.put(HEADER_IAM_API_APP_TOKEN, iamApToken);
        String tokenMode = System.getProperty(PROPERTY_SERVER_HTTP_TOKEN_MODE);
        if (StringUtils.isNotBlank((CharSequence)tokenMode) && tokenMode.equals(SERVER_HTTP_TOKEN_MODE_IAM) && (token = DWServiceContext.getContext().getToken()) != null && !token.isEmpty()) {
            requiredHeaders.put(HEADER_IAM_API_USER_TOKEN, token);
        }
        return requiredHeaders;
    }
}

