/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client;

import com.digiwin.http.client.DWHttpRetryManager;
import com.digiwin.http.client.exception.DWHttpRetryIOException;
import com.digiwin.http.context.DWHttpRetryInfo;
import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;

public class DWHttpResponseInterceptor
implements HttpResponseInterceptor {
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        int status = response.getStatusLine().getStatusCode();
        if (status != 200) {
            DWHttpRetryInfo retryInfo = DWHttpRetryManager.getRetryInfo(context);
            if (retryInfo == null || !retryInfo.canRetry()) {
                return;
            }
            if (retryInfo.matchResponseStatusCode(response)) {
                throw new DWHttpRetryIOException(retryInfo);
            }
        }
    }
}

