/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client.config;

import com.digiwin.http.client.config.DWAppServiceRetryConfig;
import com.digiwin.http.client.config.DWHttpRetryConfigProvider;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class DWJsonHttpRetryConfigProvider
implements DWHttpRetryConfigProvider {
    private static Log log = LogFactory.getLog(DWJsonHttpRetryConfigProvider.class);
    private static String RETRY_CONFIG_FILE_NAME = "service-retry-config.json";
    private List<DWAppServiceRetryConfig> configs;

    public DWJsonHttpRetryConfigProvider(Gson gson) {
        this.loadConfig(gson);
    }

    private void loadConfig(Gson gson) {
        List retryConfigs = null;
        if (DWJsonHttpRetryConfigProvider.class.getClassLoader().getResource(RETRY_CONFIG_FILE_NAME) == null) {
            log.info((Object)String.format("DWJsonHttpRetryConfigProvider resource=%s is not exist.", RETRY_CONFIG_FILE_NAME));
        } else {
            log.info((Object)String.format("DWJsonHttpRetryConfigProvider ready to load resource=%s...", RETRY_CONFIG_FILE_NAME));
            try (InputStream is = DWJsonHttpRetryConfigProvider.class.getClassLoader().getResourceAsStream(RETRY_CONFIG_FILE_NAME);
                 InputStreamReader isReader = new InputStreamReader(is);){
                Type configsType = TypeToken.getParameterized(List.class, (Type[])new Type[]{DWAppServiceRetryConfig.class}).getType();
                retryConfigs = (List)gson.fromJson((Reader)isReader, configsType);
            }
            catch (Exception e) {
                log.error((Object)String.format("DWJsonHttpRetryConfigProvider load resource=%s failed!", RETRY_CONFIG_FILE_NAME), (Throwable)e);
            }
        }
        if (retryConfigs == null) {
            retryConfigs = new ArrayList();
        }
        this.configs = retryConfigs;
    }

    public List<DWAppServiceRetryConfig> getConfigs() {
        return this.configs;
    }

    public DWAppServiceRetryConfig getConfig(String appId) {
        return this.configs.stream().filter(config -> Objects.equals(config.getAppId(), appId)).findFirst().orElse(null);
    }
}

