/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.context;

import com.digiwin.http.client.DWHttpRetryBackoff;
import com.digiwin.http.client.config.DWHttpRetryDefinition;
import com.digiwin.http.client.utils.DWHttpRetryPredicates;
import java.util.Objects;
import org.apache.http.HttpResponse;

public class DWHttpRetryInfo {
    private long previousBackoff;
    private int executionCount = 1;
    private DWHttpRetryDefinition sourceRetryDefinition;

    public DWHttpRetryInfo(DWHttpRetryDefinition retryDefinition) {
        Objects.requireNonNull(retryDefinition);
        this.sourceRetryDefinition = retryDefinition;
    }

    public int getRetries() {
        return this.sourceRetryDefinition.getRetries();
    }

    public int increaseExecutionCount() {
        ++this.executionCount;
        return this.executionCount;
    }

    public int getExecutionCount() {
        return this.executionCount;
    }

    public boolean canRetry() {
        return this.getRetries() >= this.executionCount;
    }

    public long getPreviousBackoff() {
        return this.previousBackoff;
    }

    public void setPreviousBackoff(long previousBackoff) {
        this.previousBackoff = previousBackoff;
    }

    public DWHttpRetryBackoff getBackoff() {
        return this.sourceRetryDefinition.getBackoff();
    }

    public boolean matchResponseStatusCode(HttpResponse response) {
        if (response == null) {
            return false;
        }
        int statusCode = response.getStatusLine().getStatusCode();
        boolean match = DWHttpRetryPredicates.matchResponseStatus(this.sourceRetryDefinition.getStatuses(), statusCode);
        return match;
    }

    public DWHttpRetryDefinition getSourceRetryDefinition() {
        return this.sourceRetryDefinition;
    }
}

