/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.iam;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.iam.HttpRequestModel;
import com.digiwin.iam.HttpRequester;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.ServiceModel;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class IAMHttpRequester {
    public static Object submit(ServiceModel model) throws Exception {
        Map<String, String> requestHeader = IAMHttpRequester.createRequestHeader(model);
        String requestBody = IAMHttpRequester.createRequestBody(model.getParams());
        HttpRequestModel requestModel = IAMHttpRequester.getHttpRequestModel();
        requestModel.setRequestBody(requestBody);
        requestModel.setRequestHeader(requestHeader);
        requestModel.setRequestMethod(model.getRequestMethod());
        String originIamUrlKey = DWServiceContext.getContext().getRequestHeader().getOrDefault("origin-iam-url-key", "");
        String crossCloudEnabled = DWApplicationConfigUtils.getProperty((String)"crossCloudEnabled");
        String iamUrl = "";
        if (StringUtils.isNotBlank((CharSequence)originIamUrlKey) && "true".equals(crossCloudEnabled)) {
            iamUrl = DWApplicationConfigUtils.getProperty((String)originIamUrlKey, (String)"");
        }
        if (StringUtils.isBlank((CharSequence)iamUrl)) {
            iamUrl = DWApplicationConfigUtils.getProperty((String)"iamUrl");
        }
        requestModel.setUrl(iamUrl + model.getInvokeURL());
        HttpResponseModel responseModel = HttpRequester.submitRequest(requestModel);
        int httpStatusCode = responseModel.getHttpStatusCode();
        if (httpStatusCode != 200) {
            DWException iamException = IAMHttpRequester.handleHttpStatus(requestModel, responseModel);
            throw iamException;
        }
        return responseModel;
    }

    public static HttpRequestModel getHttpRequestModel() {
        HttpRequestModel requestModel = new HttpRequestModel();
        requestModel.setContentType(DWApplicationConfigUtils.getProperty((String)"iamContentType"));
        requestModel.setCharSet(DWApplicationConfigUtils.getProperty((String)"iamCharset"));
        requestModel.setConnectionPoolRequestTimeout(Integer.parseInt(DWApplicationConfigUtils.getProperty((String)"iamHttpConnectionPoolRequestTimeout")));
        requestModel.setConnectionTimeout(Integer.parseInt(DWApplicationConfigUtils.getProperty((String)"iamHttpConnectionTimeout")));
        requestModel.setSoTimeout(Integer.parseInt(DWApplicationConfigUtils.getProperty((String)"iamSoTimeout")));
        requestModel.setEncode(DWApplicationConfigUtils.getProperty((String)"iamEncode"));
        requestModel.setMaxTotalConnections(Integer.parseInt(DWApplicationConfigUtils.getProperty((String)"iamHttpMaxConnections")));
        requestModel.setKeepAliveTimeout(Long.parseLong(DWApplicationConfigUtils.getProperty((String)"iamKeepAliveTimeout")));
        return requestModel;
    }

    public static String createRequestBody(Map<String, Object> params) throws Exception {
        Gson jsonParser = new Gson();
        String content = jsonParser.toJson(params);
        return content;
    }

    public static Map<String, String> createRequestHeader(ServiceModel model) throws Exception {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", DWApplicationConfigUtils.getProperty((String)"iamContentType") + ";" + DWApplicationConfigUtils.getProperty((String)"iamCharset"));
        String originIamUrlKey = DWServiceContext.getContext().getRequestHeader().getOrDefault("origin-iam-url-key", "");
        String iamApToken = "";
        if (StringUtils.isNotBlank((CharSequence)originIamUrlKey)) {
            iamApToken = DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-middleware-auth-app", "");
        } else {
            iamApToken = DWApplicationConfigUtils.getProperty((String)"iamApToken", (String)"");
            if (iamApToken.isEmpty()) {
                iamApToken = DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-middleware-auth-app", "");
            }
        }
        header.put("digi-middleware-auth-app", iamApToken);
        String tokenMode = System.getProperty("serverHttpTokenmode");
        if (StringUtils.isNotBlank((CharSequence)tokenMode) && tokenMode.equals("IAM")) {
            header.put("digi-middleware-auth-user", model.getToken());
        }
        return header;
    }

    @Deprecated
    public static void handleHttpStatus(int httpStatusCode) throws Exception {
        if (httpStatusCode == 500) {
            throw new Exception("IAM \u7cfb\u7edf\u9519\u8bef\uff0c\u66f4\u591a\u8d44\u8baf\u8bf7\u67e5\u8be2\u7cfb\u7edf\u8bb0\u5f55!");
        }
        if (httpStatusCode == 503) {
            throw new Exception("IAM \u5916\u90e8\u8fde\u63a5\u670d\u52a1\u5f02\u5e38\uff0c\u53ef\u80fd\u662f\u65e0\u6cd5\u8fde\u7ebf\u5230\u540e\u7aef\u8d44\u6599\u5e93!");
        }
        if (httpStatusCode == 406) {
            throw new Exception("IAM AP TOKEN \u932f\u8aa4!");
        }
    }

    public static DWException handleHttpStatus(HttpRequestModel requestModel, HttpResponseModel responseModel) throws Exception {
        String iamErrorMessageFormat = "IAM\u8acb\u6c42\u5931\u6557,\u8acb\u6c42url\u70ba%s,\u8acb\u6c42Header\u70ba%s,\u8acb\u6c42body\u70ba%s, \u56de\u61c9\u72c0\u614b\u78bc\u70ba%d\uff0c\u56de\u61c9body\u70ba%s ";
        String iamErrorMessage = String.format(iamErrorMessageFormat, requestModel.getUrl(), requestModel.getRequestHeader().toString(), requestModel.getRequestBody(), responseModel.getHttpStatusCode(), responseModel.getResponseBody());
        boolean login = false;
        String errorCode = "10903";
        if (responseModel.getHttpStatusCode() == 406 || responseModel.getHttpStatusCode() == 401) {
            errorCode = "10904";
            login = true;
        }
        DWException exception = new DWException(errorCode, iamErrorMessage);
        if (login) {
            exception.getInstructors().put("login", true);
        }
        return exception;
    }
}

