/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.iam;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import java.util.HashMap;
import org.json.JSONObject;

public class IAMIdentityService {
    public String getToken(String secretKey) throws Exception {
        HttpResponseModel iamResponse = this.login(secretKey);
        String responseBody = iamResponse.getResponseBody();
        JSONObject responseJson = new JSONObject(responseBody);
        String token = (String)responseJson.get("token");
        return token;
    }

    public HttpResponseModel login(String secretKey) throws Exception {
        ServiceModel serviceModel = new ServiceModel();
        String invokeURL = DWApplicationConfigUtils.getProperty((String)"iamUrlLogin");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("secretKey", secretKey);
        params.put("identityType", "secretKey");
        serviceModel.setInvokeURL(invokeURL);
        serviceModel.setParams(params);
        serviceModel.setRequestMethod(DWRequestMethod.POST);
        HttpResponseModel iamResponse = (HttpResponseModel)IAMService.invoke(serviceModel);
        this.handleLoginWithError(iamResponse);
        return iamResponse;
    }

    public void handleLoginWithError(HttpResponseModel response) throws Exception {
        String responseBody = response.getResponseBody();
        JSONObject responseJson = new JSONObject(responseBody);
        if (responseJson.has("code")) {
            throw new DWException(responseJson.getString("detailMessage"));
        }
    }
}

