/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.iam;

import com.digiwin.app.cache.DWCacheable;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.gateway.config.DWHttpConnectionConfig;
import com.digiwin.gateway.config.DWHttpRequestConfig;
import com.digiwin.http.client.DWConnectKeepAliveStrategy;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.utils.DWAppUriUtils;
import com.digiwin.http.client.utils.DWRequestHeaderUtils;
import com.digiwin.http.client.utils.DWURIBuilder;
import com.digiwin.iam.HttpRequestModel;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMHttpRequester;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;

public class UserTokenService {
    private DWHttpClient httpClient;

    public UserTokenService() {
        HttpRequestModel model = IAMHttpRequester.getHttpRequestModel();
        DWHttpRequestConfig requestConfig = new DWHttpRequestConfig();
        requestConfig.setSocketTimeout(model.getSoTimeout());
        requestConfig.setConnectTimeout(model.getConnectionTimeout());
        requestConfig.setConnectionRequestTimeout(model.getConnectionPoolRequestTimeout());
        DWHttpConnectionConfig connectionConfig = new DWHttpConnectionConfig();
        connectionConfig.setMaxTotal(model.getMaxTotalConnections());
        connectionConfig.setDefaultMaxPerRoute(model.getMaxTotalConnections());
        long keepAliveTimeput = model.getKeepAliveTimeout();
        DWConnectKeepAliveStrategy strategy = new DWConnectKeepAliveStrategy();
        strategy.setKeepAliveTimeout(keepAliveTimeput);
        this.httpClient = new DWHttpClient(connectionConfig, requestConfig, (DefaultConnectionKeepAliveStrategy)strategy);
    }

    @DWCacheable(value="token")
    public HttpResponseModel verifyToken(String token) throws Exception {
        return this.verifyTokenCommon(token);
    }

    public HttpResponseModel verifyTokenWithoutCache(String token) throws Exception {
        return this.verifyTokenCommon(token);
    }

    public HttpResponseModel verifyTokenCommon(String token) throws Exception {
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new DWBusinessException("userToken \u4e0d\u53ef\u70ba\u7a7a");
        }
        String IAM_LOGIN = DWApplicationConfigUtils.getProperty((String)"iamUrlUsertokenAnalyze");
        HashMap<String, Object> params = new HashMap<String, Object>();
        HttpResponseModel result = this.invokeIAMWithDWHttpClient(IAM_LOGIN, params, token);
        return result;
    }

    public HttpResponseModel invokeIAMWithDWHttpClient(String invokeURL, Map<String, Object> params, String token) throws Exception {
        HttpResponseModel responseModel;
        String servicePath = DWApplicationConfigUtils.getProperty((String)"iamUrlUsertokenAnalyze");
        URI uri = DWURIBuilder.create((String)"iam", (String)invokeURL).build();
        HttpPost post = new HttpPost(uri);
        Map headers = DWRequestHeaderUtils.getIamApiRequiredHeaders();
        headers.put("Content-Type", "application/json;charset=UTF-8");
        headers.put("digi-middleware-auth-user", token);
        String responseBody = "";
        HttpResponse response = this.httpClient.execute((HttpUriRequest)post, () -> headers);
        int statusCode = response.getStatusLine().getStatusCode();
        try (InputStream responseStream = response.getEntity().getContent();){
            if (responseStream != null) {
                responseBody = IOUtils.toString((InputStream)responseStream, (Charset)StandardCharsets.UTF_8);
            }
            responseModel = new HttpResponseModel(statusCode, responseBody);
        }
        if (responseModel.getHttpStatusCode() != 200) {
            HttpRequestModel requestModel = new HttpRequestModel();
            requestModel.setUrl(DWAppUriUtils.getIAMUri() + invokeURL);
            requestModel.setRequestHeader(headers);
            requestModel.setRequestBody("");
            DWException iamException = IAMHttpRequester.handleHttpStatus(requestModel, responseModel);
            throw iamException;
        }
        return responseModel;
    }

    public static Object invokeIAM(String invokeURL, Map<String, Object> params, String token) throws Exception {
        ServiceModel serviceModel = new ServiceModel();
        serviceModel.setInvokeURL(invokeURL);
        serviceModel.setParams(params);
        serviceModel.setToken(token);
        Object returnObj = IAMService.invoke(serviceModel);
        return returnObj;
    }
}

