/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.iam;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.resource.DWApplicationMessageResourceBundleUtils;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.http.client.exception.DWExternalAPIHttpFailedException;
import com.digiwin.iam.HttpRequestModel;
import com.digiwin.iam.HttpRequester;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.ServiceModel;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class IAMHttpRequester {
    public static Object submit(ServiceModel model) throws Exception {
        Map<String, String> requestHeader = IAMHttpRequester.createRequestHeader(model);
        String requestBody = null;
        if (model.getParams() != null) {
            requestBody = IAMHttpRequester.createRequestBody(model.getParams());
        } else if (model.getBody() != null) {
            requestBody = IAMHttpRequester.createRequestBody(model.getBody());
        }
        HttpRequestModel requestModel = IAMHttpRequester.getHttpRequestModel();
        requestModel.setRequestBody(requestBody);
        requestModel.setRequestHeader(requestHeader);
        requestModel.setRequestMethod(model.getRequestMethod());
        String iamUrl = DWApplicationConfigUtils.getProperty((String)"iamUrl");
        requestModel.setUrl(iamUrl + model.getInvokeURL());
        HttpResponseModel responseModel = HttpRequester.submitRequest(requestModel);
        int httpStatusCode = responseModel.getHttpStatusCode();
        if (httpStatusCode != 200) {
            DWException iamException = IAMHttpRequester.handleHttpStatus(requestModel, responseModel);
            throw iamException;
        }
        return responseModel;
    }

    public static HttpRequestModel getHttpRequestModel() {
        HttpRequestModel requestModel = new HttpRequestModel();
        requestModel.setContentType(DWApplicationConfigUtils.getProperty((String)"iamContentType"));
        requestModel.setCharSet(DWApplicationConfigUtils.getProperty((String)"iamCharset"));
        requestModel.setConnectionPoolRequestTimeout(Integer.parseInt(DWApplicationConfigUtils.getProperty((String)"iamHttpConnectionPoolRequestTimeout")));
        requestModel.setConnectionTimeout(Integer.parseInt(DWApplicationConfigUtils.getProperty((String)"iamHttpConnectionTimeout")));
        requestModel.setSoTimeout(Integer.parseInt(DWApplicationConfigUtils.getProperty((String)"iamSoTimeout")));
        requestModel.setEncode(DWApplicationConfigUtils.getProperty((String)"iamEncode"));
        requestModel.setMaxTotalConnections(Integer.parseInt(DWApplicationConfigUtils.getProperty((String)"iamHttpMaxConnections")));
        requestModel.setKeepAliveTimeout(Long.parseLong(DWApplicationConfigUtils.getProperty((String)"iamKeepAliveTimeout")));
        return requestModel;
    }

    public static String createRequestBody(Object params) throws Exception {
        Gson jsonParser = new Gson();
        String content = jsonParser.toJson(params);
        return content;
    }

    public static Map<String, String> createRequestHeader(ServiceModel model) throws Exception {
        Locale locale;
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", DWApplicationConfigUtils.getProperty((String)"iamContentType") + ";" + DWApplicationConfigUtils.getProperty((String)"iamCharset"));
        String iamApToken = DWApplicationConfigUtils.getProperty((String)"iamApToken", (String)"");
        if (iamApToken.isEmpty()) {
            iamApToken = DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-middleware-auth-app", "");
        }
        header.put("digi-middleware-auth-app", iamApToken);
        String tokenMode = DWApplicationConfigUtils.getProperty((String)"serverHttpTokenmode");
        if (StringUtils.isNotBlank((CharSequence)tokenMode) && tokenMode.equals("IAM")) {
            header.put("digi-middleware-auth-user", model.getToken());
        }
        if ((locale = DWResourceBundleUtils.getCurrentLocale()) != null) {
            header.put("Accept-Language", locale.toLanguageTag());
        }
        return header;
    }

    @Deprecated
    public static void handleHttpStatus(int httpStatusCode) throws Exception {
        if (httpStatusCode == 500) {
            throw new Exception("IAM \u7cfb\u7edf\u9519\u8bef\uff0c\u66f4\u591a\u8d44\u8baf\u8bf7\u67e5\u8be2\u7cfb\u7edf\u8bb0\u5f55!");
        }
        if (httpStatusCode == 503) {
            throw new Exception("IAM \u5916\u90e8\u8fde\u63a5\u670d\u52a1\u5f02\u5e38\uff0c\u53ef\u80fd\u662f\u65e0\u6cd5\u8fde\u7ebf\u5230\u540e\u7aef\u8d44\u6599\u5e93!");
        }
        if (httpStatusCode == 406) {
            throw new Exception("IAM AP TOKEN \u932f\u8aa4!");
        }
    }

    public static DWException handleHttpStatus(HttpRequestModel requestModel, HttpResponseModel responseModel) throws Exception {
        String iamErrorMessage = DWApplicationMessageResourceBundleUtils.getString((String)"10900", (Object[])new Object[]{requestModel.getUrl(), requestModel.getRequestHeader().toString(), requestModel.getRequestBody(), responseModel.getHttpStatusCode(), responseModel.getResponseBody()});
        boolean login = false;
        String errorCode = "10903";
        if (responseModel.getHttpStatusCode() == 406 || responseModel.getHttpStatusCode() == 401) {
            errorCode = "10904";
            login = true;
        }
        DWExternalAPIHttpFailedException exception = new DWExternalAPIHttpFailedException(errorCode, iamErrorMessage, requestModel.getUrl(), responseModel.getHttpStatusCode(), responseModel.getResponseBody());
        if (login) {
            exception.getInstructors().put("login", true);
        }
        return exception;
    }
}

