/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.iam;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.DWServiceResult;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.iam.DWIAMProperties;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

public class IAMUserService {
    @Autowired
    private DWIAMProperties properties;

    public DWServiceResult getSecretKey() throws Exception {
        String token = DWServiceContext.getContext().getToken();
        return this.getSecretKey(this.properties.getAppId(), token);
    }

    public DWServiceResult getSecretKey(String appId, String token) throws Exception {
        DWServiceResult result = new DWServiceResult();
        boolean success = false;
        boolean isException = false;
        boolean foundAppId = false;
        boolean foundSecretKey = false;
        String message = "";
        String secretKey = "";
        try {
            HttpResponseModel iamResponse = this.getTenantApplication(appId, token);
            JSONArray applicationArray = new JSONArray(iamResponse.getResponseBody());
            for (int j = 0; j < applicationArray.length(); ++j) {
                JSONObject application = applicationArray.getJSONObject(j);
                if (!appId.equals(application.getString("id"))) continue;
                foundAppId = true;
                if (!application.has("secretKey")) continue;
                foundSecretKey = true;
                secretKey = application.getString("secretKey");
                break;
            }
        }
        catch (Exception e) {
            isException = true;
            message = e.getMessage();
        }
        if (isException) {
            success = false;
        } else if (!foundAppId) {
            success = false;
            message = String.format("App id %s not found", appId);
        } else if (!foundSecretKey) {
            success = false;
            message = String.format("App id %s secret key not found", appId);
        } else {
            success = true;
            message = String.format("App id %s secret key found", appId);
        }
        result.setSuccess((Object)success);
        result.setData((Object)secretKey);
        result.setMessage(message);
        return result;
    }

    public HttpResponseModel getTenantApplication() throws Exception {
        String token = DWServiceContext.getContext().getToken();
        String appId = this.properties.getAppId();
        return this.getTenantApplication(appId, token);
    }

    public HttpResponseModel getTenantApplication(String appId, String token) throws Exception {
        ServiceModel serviceModel = new ServiceModel();
        String invokeURL = this.properties.getApiPathUserTenantApplication();
        serviceModel.setInvokeURL(invokeURL);
        serviceModel.setParams(new HashMap<String, Object>());
        serviceModel.setRequestMethod(DWRequestMethod.GET);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            serviceModel.setToken(token);
        }
        HttpResponseModel iamResponse = (HttpResponseModel)IAMService.invoke(serviceModel);
        return iamResponse;
    }
}

