/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.iam;

import com.digiwin.gateway.config.DWHttpConnectionConfig;
import com.digiwin.gateway.config.DWHttpRequestConfig;
import com.digiwin.http.client.DWConnectKeepAliveStrategy;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.entity.DWJsonEntity;
import com.digiwin.http.client.utils.DWAppUriUtils;
import com.digiwin.http.client.utils.DWRequestHeaderUtils;
import com.digiwin.http.client.utils.DWURIBuilder;
import com.digiwin.iam.HttpRequestModel;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMHttpRequester;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;

public class IAMCommonService {
    DWHttpClient httpClient;

    public IAMCommonService() {
        HttpRequestModel model = IAMHttpRequester.getHttpRequestModel();
        DWHttpRequestConfig requestConfig = new DWHttpRequestConfig();
        requestConfig.setSocketTimeout(model.getSoTimeout());
        requestConfig.setConnectTimeout(model.getConnectionTimeout());
        requestConfig.setConnectionRequestTimeout(model.getConnectionPoolRequestTimeout());
        DWHttpConnectionConfig connectionConfig = new DWHttpConnectionConfig();
        connectionConfig.setMaxTotal(model.getMaxTotalConnections());
        connectionConfig.setDefaultMaxPerRoute(model.getMaxTotalConnections());
        long keepAliveTimeout = model.getKeepAliveTimeout();
        DWConnectKeepAliveStrategy strategy = new DWConnectKeepAliveStrategy();
        strategy.setKeepAliveTimeout(keepAliveTimeout);
        this.httpClient = new DWHttpClient(connectionConfig, requestConfig, (DefaultConnectionKeepAliveStrategy)strategy);
    }

    public HttpResponseModel invokeIAMWithDWHttpClient(String invokeURL, Map<String, Object> params, String token) throws Exception {
        HttpResponseModel responseModel;
        URI uri = DWURIBuilder.create((String)"iam", (String)invokeURL).build();
        HttpPost post = new HttpPost(uri);
        if (!params.isEmpty()) {
            post.setEntity((HttpEntity)new DWJsonEntity(params));
        }
        Map headers = DWRequestHeaderUtils.getIamApiRequiredHeaders();
        headers.put("Content-Type", "application/json;charset=UTF-8");
        headers.put("digi-middleware-auth-user", token);
        String responseBody = "";
        HttpResponse response = this.httpClient.execute((HttpUriRequest)post, () -> headers);
        int statusCode = response.getStatusLine().getStatusCode();
        try (InputStream responseStream = response.getEntity().getContent();){
            if (responseStream != null) {
                responseBody = IOUtils.toString((InputStream)responseStream, (Charset)StandardCharsets.UTF_8);
            }
            responseModel = new HttpResponseModel(statusCode, responseBody);
        }
        if (responseModel.getHttpStatusCode() != 200) {
            HttpRequestModel requestModel = new HttpRequestModel();
            requestModel.setUrl(DWAppUriUtils.getIAMUri() + invokeURL);
            requestModel.setRequestHeader(headers);
            requestModel.setRequestBody("");
            throw IAMHttpRequester.handleHttpStatus(requestModel, responseModel);
        }
        return responseModel;
    }
}

