/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.iam;

import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.iam.DWIAMProperties;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMCommonService;
import com.digiwin.iam.response.IAMUserAllInfoResponseModel;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class IAMUserAllInfoService {
    @Autowired
    IAMCommonService iamCommonService;
    @Autowired
    private DWIAMProperties properties;
    public static final String USER_TYPE_DIGIWIN_CLOUD = "0";
    public static final String USER_TYPE_ENTERPRISE = "1";
    static final String USER_STATUS_ALL = "all";
    static final String USER_STATUS_ENABLED = "enabled";
    static final String USER_STATUS_DISABLED = "disabled";

    public IAMUserAllInfoResponseModel queryAllUserInfo(int pageSize, int pageNumber) throws Exception {
        return this.queryAllUserInfo(pageSize, pageNumber, null, null);
    }

    public IAMUserAllInfoResponseModel queryAllUserInfo(int pageSize, int pageNumber, String content, String userType) throws Exception {
        return this.queryUserInfo(pageSize, pageNumber, USER_STATUS_ALL, content, userType);
    }

    public IAMUserAllInfoResponseModel queryEnabledUserInfo(int pageSize, int pageNumber) throws Exception {
        return this.queryEnabledUserInfo(pageSize, pageNumber, null, null);
    }

    public IAMUserAllInfoResponseModel queryEnabledUserInfo(int pageSize, int pageNumber, String content, String userType) throws Exception {
        return this.queryUserInfo(pageSize, pageNumber, USER_STATUS_ENABLED, content, userType);
    }

    public IAMUserAllInfoResponseModel queryDisabledUserInfo(int pageSize, int pageNumber) throws Exception {
        return this.queryDisabledUserInfo(pageSize, pageNumber, null, null);
    }

    public IAMUserAllInfoResponseModel queryDisabledUserInfo(int pageSize, int pageNumber, String content, String userType) throws Exception {
        return this.queryUserInfo(pageSize, pageNumber, USER_STATUS_DISABLED, content, userType);
    }

    public IAMUserAllInfoResponseModel queryUserInfo(int pageSize, int pageNumber, String userStatus, String content, String userType) throws Exception {
        if (StringUtils.isEmpty((CharSequence)userStatus)) {
            throw new DWArgumentException("userStatus", "userStatus \u4e0d\u80fd\u70ba\u7a7a\u3002");
        }
        HashMap<String, Object> queryPage = new HashMap<String, Object>();
        queryPage.put("pageCount", pageSize);
        queryPage.put("pageNumber", pageNumber);
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            queryPage.put("content", content);
        }
        if (StringUtils.isNotEmpty((CharSequence)userType)) {
            queryPage.put("userType", userType);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", userStatus);
        params.put("queryPage", queryPage);
        String invokeURL = this.properties.getApiPathUserAllInfo();
        String token = Objects.toString(DWServiceContext.getContext().getRequestHeader().get("token"));
        if (Objects.isNull(token)) {
            token = Objects.toString(DWServiceContext.getContext().getRequestHeader().get("digi-middleware-auth-user"));
        }
        HttpResponseModel responseModel = this.iamCommonService.invokeIAMWithDWHttpClient(invokeURL, params, token);
        return new IAMUserAllInfoResponseModel(responseModel);
    }
}

