/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.iot.mqtt.utils;

import com.digiwin.app.iot.mqtt.DWMqttClientFactory;
import com.digiwin.app.iot.mqtt.DWMqttConfiguration;
import com.digiwin.app.iot.mqtt.callback.DWMqttMessageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class DWMqttUtil {
    private static final Log _log = LogFactory.getLog(DWMqttUtil.class);

    public static Object sendMessage(String topic, String message) throws Exception {
        DWMqttClientFactory clientFactory = DWMqttConfiguration.getInstance();
        String clientId = clientFactory.getClientId();
        IMqttDeliveryToken token = (IMqttDeliveryToken)DWMqttUtil.sendMessage(topic, message, clientId);
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object sendMessage(String topic, String message, String clientId) throws Exception {
        DWMqttClientFactory clientFactory = DWMqttConfiguration.getInstance();
        MqttMessage mqttMessage = new MqttMessage(message.getBytes());
        mqttMessage.setRetained(clientFactory.isTopicRetained());
        mqttMessage.setQos(clientFactory.getTopicQos());
        IMqttAsyncClient mqttClient = null;
        IMqttDeliveryToken token = null;
        try {
            mqttClient = clientFactory.createAndConnectAsyncClient(clientId);
            token = mqttClient.publish(topic, mqttMessage);
            _log.debug((Object)(clientId + " publishing to..." + topic + ",payload=" + message));
        }
        finally {
            if (mqttClient != null && mqttClient.isConnected()) {
                mqttClient.disconnect();
                _log.debug((Object)" -- mqtt disconnect");
            }
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fetchMessage(String topic) throws Exception {
        DWMqttClientFactory clientFactory = DWMqttConfiguration.getInstance();
        String messageStr = "";
        IMqttAsyncClient mqttClient = null;
        MqttMessage mqttMessage = null;
        try {
            DWMqttMessageListener listener = new DWMqttMessageListener();
            mqttClient = clientFactory.createAndConnectAsyncClient(clientFactory.getClientId());
            mqttClient.subscribe(topic, clientFactory.getTopicQos(), (IMqttMessageListener)listener).waitForCompletion(clientFactory.getConnectTimeout());
            mqttMessage = listener.getNextMessage();
            if (mqttMessage != null) {
                messageStr = new String(mqttMessage.getPayload());
            }
            _log.debug((Object)("Subscribe topic=" + topic + ", message=" + messageStr));
        }
        finally {
            if (mqttClient != null && mqttClient.isConnected()) {
                mqttClient.disconnect();
                _log.debug((Object)" -- mqtt disconnect");
            }
        }
        return mqttMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fetchMessage(String topic, String clientId) throws Exception {
        DWMqttClientFactory clientFactory = DWMqttConfiguration.getInstance();
        String messageStr = "";
        IMqttAsyncClient mqttClient = null;
        MqttMessage mqttMessage = null;
        try {
            DWMqttMessageListener listener = new DWMqttMessageListener();
            mqttClient = clientFactory.createAndConnectAsyncClient(clientId);
            mqttClient.subscribe(topic, clientFactory.getTopicQos(), (IMqttMessageListener)listener).waitForCompletion();
            mqttMessage = listener.getNextMessage();
            if (mqttMessage != null) {
                messageStr = new String(mqttMessage.getPayload());
            }
            _log.debug((Object)("Subscribe topic=" + topic + ", message=" + messageStr));
        }
        finally {
            if (mqttClient != null && mqttClient.isConnected()) {
                mqttClient.disconnect();
                _log.debug((Object)" -- mqtt disconnect");
            }
        }
        return mqttMessage;
    }
}

