/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.iot.mqtt;

import com.digiwin.app.iot.DWIoTClientFactory;
import com.digiwin.app.iot.mqtt.ClientType;
import com.digiwin.app.iot.mqtt.DWMqttAsyncClient;
import com.digiwin.app.iot.mqtt.DWMqttClient;
import com.digiwin.app.iot.mqtt.DWMqttConfiguration;
import com.digiwin.app.iot.mqtt.callback.DWMqttCallback;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class DWMqttClientFactory
implements DWIoTClientFactory {
    private MqttConnectOptions connectionOptions = new MqttConnectOptions();
    private MqttClientPersistence persistence;
    private String serverURI;
    private boolean topicRetained;
    private int topicQos = 1;
    private String clientId;
    private long connectTimeout = 3000L;
    private MqttCallback callback;
    private long waitForCompletion = 10000L;
    private static DWMqttClientFactory dwMqttClientFactory;

    public static DWMqttClientFactory getInstance() throws Exception {
        if (dwMqttClientFactory == null) {
            dwMqttClientFactory = DWMqttConfiguration.getInstance();
        }
        return dwMqttClientFactory;
    }

    public MqttConnectOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    public void setConnectionOptions(MqttConnectOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
    }

    public MqttClientPersistence getPersistence() {
        return this.persistence;
    }

    public void setPersistence(MqttClientPersistence persistence) {
        this.persistence = persistence;
    }

    public String getServerURI() {
        return this.serverURI;
    }

    public void setServerURI(String serverURI) {
        this.serverURI = serverURI;
    }

    public IMqttClient createMqttClient(String clientId) throws Exception {
        return new DWMqttClient(this.serverURI, clientId);
    }

    public IMqttClient createMqttClient(String serverURI, String clientId) throws Exception {
        return new DWMqttClient(serverURI, clientId, this.connectionOptions);
    }

    public IMqttClient createMqttClient(String clientId, MqttClientPersistence persistence) throws Exception {
        return this.createMqttClient(this.serverURI, clientId, persistence);
    }

    public IMqttClient createAndConnectMqttClient(String clientId, MqttClientPersistence persistence) throws Exception {
        DWMqttClient mqttClient = new DWMqttClient(this.serverURI, clientId, persistence);
        this.beforeConnect((Object)mqttClient, this.callback);
        if (this.connectionOptions != null) {
            mqttClient.connect(this.connectionOptions);
        } else {
            mqttClient.connect();
        }
        return mqttClient;
    }

    public IMqttClient createAndConnectMqttClient(String clientId) throws Exception {
        return this.createAndConnectMqttClient(clientId, this.persistence);
    }

    public IMqttClient createMqttClient(String serverURI, String clientId, MqttClientPersistence persistence) throws Exception {
        return new DWMqttClient(serverURI, clientId, this.persistence);
    }

    public IMqttAsyncClient createAsyncMqttClient(String serverURI, String clientId) throws Exception {
        return new DWMqttAsyncClient(serverURI, clientId);
    }

    public IMqttAsyncClient createAndConnectAsyncClient(String clientId) throws Exception {
        return (IMqttAsyncClient)this.createAndConnectAsyncClient(clientId, this.callback);
    }

    public IMqttAsyncClient createMqttAsyncClient(String serverURI, String clientId, MqttClientPersistence persistence) throws Exception {
        return new DWMqttAsyncClient(serverURI, clientId, persistence);
    }

    public IMqttAsyncClient createMqttAsyncClient(String clientId, MqttClientPersistence persistence) throws Exception {
        return this.createMqttAsyncClient(this.serverURI, clientId, persistence);
    }

    public IMqttAsyncClient createMqttAsyncClient(String clientId) throws Exception {
        return this.createMqttAsyncClient(this.serverURI, clientId, this.persistence);
    }

    @Override
    public boolean isTopicRetained() {
        return this.topicRetained;
    }

    public void setTopicRetained(boolean topicRetained) {
        this.topicRetained = topicRetained;
    }

    @Override
    public int getTopicQos() {
        return this.topicQos;
    }

    public void setTopicQos(int topicQos) {
        this.topicQos = topicQos;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public MqttCallback getCallback() {
        return this.callback;
    }

    @Override
    public void setCallback(Object callback) {
        this.callback = (MqttCallback)callback;
    }

    public long getWaitForCompletion() {
        return this.waitForCompletion;
    }

    public void setWaitForCompletion(long waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
    }

    @Override
    public Object createAndConnectClient(String clientId, ClientType clientSyncType) throws Exception {
        Object result = this.createAndConnectClient(clientId, clientSyncType, this.callback);
        return result;
    }

    public Object createAndConnectClient(String clientId, ClientType clientSyncType, MqttCallback mqttCallback) throws Exception {
        Object result;
        switch (StringUtils.lowerCase((String)clientSyncType.toString())) {
            case "async": {
                result = this.createAndConnectAsyncClient(clientId, mqttCallback);
                break;
            }
            default: {
                result = this.createAndConnectMqttClient(clientId, mqttCallback);
            }
        }
        return result;
    }

    public Object createAndConnectAsyncClient(String clientId, MqttCallback mqttCallback) throws Exception {
        return this.createAndConnectAsyncClient(clientId, this.connectionOptions, mqttCallback);
    }

    public Object createAndConnectAsyncClient(String clientId, MqttConnectOptions connectionOptions, MqttCallback mqttCallback) throws Exception {
        if (this.persistence == null) {
            this.persistence = new MemoryPersistence();
        }
        DWMqttAsyncClient mqttClient = new DWMqttAsyncClient(this.serverURI, clientId, this.persistence);
        this.beforeConnect((Object)mqttClient, mqttCallback);
        if (connectionOptions != null) {
            mqttClient.connect(connectionOptions).waitForCompletion(this.connectTimeout);
        } else {
            mqttClient.connect().waitForCompletion(this.connectTimeout);
        }
        return mqttClient;
    }

    public IMqttClient createAndConnectMqttClient(String clientId, MqttCallback mqttCallback) throws Exception {
        DWMqttClient mqttClient = new DWMqttClient(this.serverURI, clientId, this.persistence);
        this.beforeConnect((Object)mqttClient, mqttCallback);
        if (this.connectionOptions != null) {
            mqttClient.connect(this.connectionOptions);
        } else {
            mqttClient.connect();
        }
        return mqttClient;
    }

    public void beforeConnect(Object mqttClient, MqttCallback mqttCallback) {
        if (mqttCallback != null && mqttClient != null) {
            if (mqttCallback instanceof DWMqttCallback) {
                ((DWMqttCallback)mqttCallback).setMqttClient(mqttClient);
            }
            if (mqttClient instanceof IMqttAsyncClient) {
                ((IMqttAsyncClient)mqttClient).setCallback(mqttCallback);
            } else if (mqttClient instanceof IMqttClient) {
                ((IMqttClient)mqttClient).setCallback(mqttCallback);
            }
        }
    }
}

