/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.iot.mqtt.utils;

import com.digiwin.app.iot.mqtt.DWMqttClientFactory;
import com.digiwin.app.iot.mqtt.DWMqttConfiguration;
import com.digiwin.app.iot.mqtt.callback.DWMqttCallback;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class DWMqttUtil {
    private static final Log _log = LogFactory.getLog(DWMqttUtil.class);
    private static int loopInterval = 500;

    public static Object sendMessage(String topic, String message) throws Exception {
        DWMqttClientFactory clientFactory = DWMqttConfiguration.getInstance();
        String clientId = clientFactory.getClientId();
        IMqttDeliveryToken token = (IMqttDeliveryToken)DWMqttUtil.sendMessage(topic, message, clientId);
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object sendMessage(String topic, String message, String clientId) throws Exception {
        DWMqttClientFactory clientFactory = DWMqttConfiguration.getInstance();
        MqttMessage mqttMessage = new MqttMessage(message.getBytes());
        mqttMessage.setRetained(clientFactory.isTopicRetained());
        mqttMessage.setQos(clientFactory.getTopicQos());
        IMqttAsyncClient mqttClient = null;
        IMqttDeliveryToken token = null;
        try {
            mqttClient = clientFactory.createAndConnectAsyncClient(clientId);
            token = mqttClient.publish(topic, mqttMessage);
            token.waitForCompletion(clientFactory.getWaitForCompletion());
            _log.debug((Object)(clientId + " publishing to..." + topic + ",payload=" + message));
        }
        finally {
            if (mqttClient != null && mqttClient.isConnected()) {
                mqttClient.disconnect();
                _log.debug((Object)" -- mqtt disconnect");
            }
        }
        return token;
    }

    public static Object fetchMessage(String topic) throws Exception {
        DWMqttClientFactory clientFactory = DWMqttConfiguration.getInstance();
        Object mqttMessage = DWMqttUtil.fetchMessage(topic, clientFactory.getClientId());
        return mqttMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fetchMessage(String topic, String clientId) throws Exception {
        DWMqttClientFactory clientFactory = DWMqttConfiguration.getInstance();
        IMqttAsyncClient mqttClient = null;
        MqttMessage mqttMessage = null;
        try {
            DWMqttCallback dwMqttCallback = new DWMqttCallback(topic);
            mqttClient = (IMqttAsyncClient)clientFactory.createAndConnectAsyncClient(clientId, (MqttCallback)dwMqttCallback);
            mqttClient.subscribe(topic, clientFactory.getTopicQos()).waitForCompletion(clientFactory.getWaitForCompletion());
            for (int i = 0; i < 3; ++i) {
                Thread.sleep(loopInterval);
                Map responseMessage = (Map)dwMqttCallback.getNextMessage();
                if (responseMessage != null) {
                    mqttMessage = (MqttMessage)responseMessage.get("message");
                    String messageTopic = (String)responseMessage.get("topic");
                    String message = new String(mqttMessage.getPayload());
                    _log.debug((Object)("-- mqtt(" + i + ")-- message topic=" + messageTopic + ", message=" + message));
                    break;
                }
                _log.debug((Object)("-- mqtt(" + i + ")--- message topic=null"));
            }
        }
        finally {
            if (mqttClient != null && mqttClient.isConnected()) {
                mqttClient.disconnect();
                _log.debug((Object)" +- mqtt disconnect");
            }
        }
        return mqttMessage;
    }
}

