/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.iot.mqtt;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.iot.mqtt.DWMqttClientFactory;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;

public class DWMqttConfiguration {
    private static final Log _log = LogFactory.getLog(DWMqttConfiguration.class);
    private static final String _CLASSTAG = "[DWMqttConfiguration]";
    private static String host;
    private static String username;
    private static String password;
    private static String connectTimeout;
    private static String autoReconnect;
    private static String cleanSession;
    private static String topicQos;
    private static String topicRetained;
    private static String clientId;
    private static String waitForCompletion;
    private static DWMqttClientFactory dwMqttClientFactory;
    private static DWMqttClientFactory defaultDWMqttClientFactory;
    private static boolean mqttEnabled;

    private static void init() throws Exception {
        host = DWApplicationConfigUtils.getProperty((String)"mqttSrvHost");
        mqttEnabled = DWMqttConfiguration.configValid(host);
        if (mqttEnabled) {
            username = DWApplicationConfigUtils.getProperty((String)"mqttSrvUsername", (String)"");
            password = DWApplicationConfigUtils.getProperty((String)"mqttSrvPassword", (String)"");
            autoReconnect = DWApplicationConfigUtils.getProperty((String)"mqttSrvReconnect", (String)"true");
            cleanSession = DWApplicationConfigUtils.getProperty((String)"mqttSrvCleanSession", (String)"false");
            topicRetained = DWApplicationConfigUtils.getProperty((String)"mqttTopicRetained", (String)"true");
            clientId = DWApplicationConfigUtils.getProperty((String)"mqttSrvClientId", (String)"superman999");
            connectTimeout = DWApplicationConfigUtils.getProperty((String)"mqttSrvConnectTimeout", (String)"5000");
            topicQos = DWApplicationConfigUtils.getProperty((String)"mqttTopicQos", (String)"1");
            waitForCompletion = DWApplicationConfigUtils.getProperty((String)"mqttWaitForCompletion", (String)"10000");
            dwMqttClientFactory = null;
            defaultDWMqttClientFactory = null;
        } else {
            dwMqttClientFactory = DWMqttConfiguration.getInstance();
        }
    }

    public static DWMqttClientFactory getInstance() throws Exception {
        if (!mqttEnabled) {
            throw new DWArgumentException("DWMqttConfiguration", "mqtt enabled is false");
        }
        if (defaultDWMqttClientFactory != null) {
            return defaultDWMqttClientFactory.clone();
        }
        dwMqttClientFactory = new DWMqttClientFactory();
        MqttConnectOptions connectionOptions = new MqttConnectOptions();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            connectionOptions.setUserName(username);
        }
        if (StringUtils.isNotBlank((CharSequence)password)) {
            connectionOptions.setPassword(password.toCharArray());
        }
        if (StringUtils.isNotBlank((CharSequence)cleanSession)) {
            connectionOptions.setCleanSession(new Boolean(cleanSession).booleanValue());
        }
        if (StringUtils.isNotBlank((CharSequence)autoReconnect)) {
            connectionOptions.setAutomaticReconnect(new Boolean(autoReconnect).booleanValue());
        }
        dwMqttClientFactory.setServerURI(host);
        if (NumberUtils.isDigits((String)connectTimeout)) {
            int mqttConnectTimeout = Integer.parseInt(connectTimeout);
            connectionOptions.setConnectionTimeout(mqttConnectTimeout);
            dwMqttClientFactory.setConnectTimeout(mqttConnectTimeout);
        }
        if (StringUtils.isNotBlank((CharSequence)topicRetained)) {
            dwMqttClientFactory.setTopicRetained(new Boolean(topicRetained));
        }
        if (StringUtils.isBlank((CharSequence)clientId)) {
            clientId = UUID.randomUUID().toString();
        }
        dwMqttClientFactory.setClientId(clientId);
        if (NumberUtils.isDigits((String)topicQos)) {
            dwMqttClientFactory.setTopicQos(Integer.parseInt(topicQos));
        }
        if (NumberUtils.isDigits((String)waitForCompletion)) {
            dwMqttClientFactory.setWaitForCompletion(Integer.parseInt(waitForCompletion));
        }
        dwMqttClientFactory.setConnectionOptions(connectionOptions);
        defaultDWMqttClientFactory = dwMqttClientFactory.clone();
        return dwMqttClientFactory;
    }

    public static DWMqttClientFactory getDefaultInstance() throws Exception {
        if (!mqttEnabled) {
            throw new DWArgumentException("DWMqttConfiguration", "mqtt enabled is false");
        }
        if (dwMqttClientFactory == null) {
            DWMqttConfiguration.getInstance();
        }
        DWMqttClientFactory newDefaultDWMqttClientFactory = defaultDWMqttClientFactory.clone();
        return newDefaultDWMqttClientFactory;
    }

    public static DWMqttClientFactory reload() throws Exception {
        DWMqttConfiguration.init();
        dwMqttClientFactory = DWMqttConfiguration.getInstance();
        return dwMqttClientFactory;
    }

    private static boolean configValid(String ... property) {
        String mqttServerHost = property[0];
        boolean isMqttEnabled = false;
        if (StringUtils.isNotBlank((CharSequence)mqttServerHost) && !mqttServerHost.matches("^@(.*).@$")) {
            isMqttEnabled = true;
        }
        _log.debug((Object)("[DWMqttConfiguration] platform.properties:mqttSrvHost:" + mqttServerHost + ", mqtt enabled=" + isMqttEnabled));
        return isMqttEnabled;
    }

    public static boolean isMqttEnabled() {
        return mqttEnabled;
    }

    public static void setMqttEnabled(boolean mqttEnabled) {
        DWMqttConfiguration.mqttEnabled = mqttEnabled;
    }

    public static void setDWMqttClientFactory(DWMqttClientFactory dwMqttClientFactory) {
        DWMqttConfiguration.dwMqttClientFactory = dwMqttClientFactory;
    }

    static {
        mqttEnabled = false;
        try {
            DWMqttConfiguration.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

