/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.iot.mqtt.callback;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class DWMqttCallback
implements MqttCallbackExtended {
    private static final Log _log = LogFactory.getLog(DWMqttCallback.class);
    private static final String _CLASSTAG = "[" + DWMqttCallback.class.getSimpleName() + "]";
    private Object mqttClient;
    private String topic;
    private int qos = 1;
    private int messageWaitTimeInMicroSecond = 1000;
    private ArrayList<Object> messages = new ArrayList();

    public DWMqttCallback() {
    }

    public DWMqttCallback(String topic) {
        this.topic = topic;
    }

    public DWMqttCallback(String topic, int qos) {
        this.topic = topic;
        this.qos = qos;
    }

    public DWMqttCallback(String topic, int qos, Object mqttClient) {
        this.topic = topic;
        this.qos = qos;
        this.mqttClient = mqttClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(String topic, MqttMessage message) throws Exception {
        _log.debug((Object)(_CLASSTAG + " topic(" + topic + "),Qos(" + message.getQos() + "),message:" + new String(message.getPayload())));
        HashMap<String, String> mqttMessageResult = new HashMap<String, String>();
        mqttMessageResult.put("topic", topic);
        mqttMessageResult.put("message", (String)message);
        ArrayList<Object> arrayList = this.messages;
        synchronized (arrayList) {
            this.messages.add(mqttMessageResult);
            this.messages.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNextMessage() {
        ArrayList<Object> arrayList = this.messages;
        synchronized (arrayList) {
            if (this.messages.size() == 0) {
                try {
                    this.messages.wait(this.messageWaitTimeInMicroSecond);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.messages.size() == 0) {
                return null;
            }
            return this.messages.remove(0);
        }
    }

    public void connectionLost(Throwable cause) {
        String message = _CLASSTAG + " client connectionLost with subscribe topic(" + this.topic + ")";
        try {
            if (cause != null && cause.getMessage() != null) {
                _log.info((Object)(message + ":" + cause.getMessage()));
            } else {
                _log.info((Object)message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
        _log.debug((Object)(_CLASSTAG + " deliveryComplete in topic(" + this.topic + ") !"));
    }

    public void connectComplete(boolean reconnect, String serverURI) {
        _log.info((Object)(_CLASSTAG + " connectComplete with " + serverURI));
        if (reconnect) {
            try {
                IMqttAsyncClient asyncMqttClient;
                if (this.mqttClient instanceof IMqttClient) {
                    IMqttClient syncMqttClient = (IMqttClient)this.mqttClient;
                    if (syncMqttClient.isConnected()) {
                        syncMqttClient.subscribe(this.topic, this.qos);
                        _log.info((Object)(_CLASSTAG + "[successful] re-subscribe topic(" + this.topic + "," + this.qos + ")"));
                    }
                } else if (this.mqttClient instanceof IMqttAsyncClient && (asyncMqttClient = (IMqttAsyncClient)this.mqttClient).isConnected()) {
                    asyncMqttClient.subscribe(this.topic, this.qos);
                    _log.info((Object)(_CLASSTAG + "[successful] re-subscribe topic(" + this.topic + ")"));
                }
            }
            catch (Exception e) {
                _log.info((Object)(_CLASSTAG + "[failed] connectComplete and subscribe topic(" + this.topic + ")"));
                e.printStackTrace();
            }
        }
    }

    public Object getMqttClient() {
        return this.mqttClient;
    }

    public DWMqttCallback setMqttClient(Object mqttClient) {
        this.mqttClient = mqttClient;
        return this;
    }

    public int getMessageWaitTimeInMicroSecond() {
        return this.messageWaitTimeInMicroSecond;
    }

    public DWMqttCallback setMessageWaitTimeInMicroSecond(int messageWaitTimeInMicroSecond) {
        this.messageWaitTimeInMicroSecond = messageWaitTimeInMicroSecond;
        return this;
    }

    public String getTopic() {
        return this.topic;
    }

    public DWMqttCallback setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public int getQos() {
        return this.qos;
    }

    public DWMqttCallback setQos(int qos) {
        this.qos = qos;
        return this;
    }
}

