/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.json;

import com.digiwin.app.common.DWApplicationConfigUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;

public class DWJsonConfig {
    private static String dateTimeFormat = "yyyy/MM/dd HH:mm:ss";
    private static Boolean serializeNull = true;
    private static String numberProcessorName = "";
    private static Boolean deserializeEmptyStrToNull = false;

    @Value(value="${dap.json.date-time-format:yyyy/MM/dd HH:mm:ss}")
    public void setDateTimeFormat(String dateTimeFormat) {
        DWJsonConfig.dateTimeFormat = dateTimeFormat;
    }

    public static String getDateTimeFormat() {
        String dateTimeFormatSetting = DWApplicationConfigUtils.getProperty((String)"dap.json.dateformat");
        if (StringUtils.isNotEmpty((CharSequence)dateTimeFormatSetting)) {
            return dateTimeFormatSetting;
        }
        return dateTimeFormat;
    }

    @Value(value="${dap.json.serialize-null:true}")
    public void setSerializeNull(Boolean serializeNull) {
        DWJsonConfig.serializeNull = serializeNull;
    }

    public static Boolean getSerializeNull() {
        String serializeNullSetting = DWApplicationConfigUtils.getProperty((String)"dwJsonSerializeNulls");
        if (StringUtils.isNotEmpty((CharSequence)serializeNullSetting)) {
            return Boolean.parseBoolean(serializeNullSetting);
        }
        return serializeNull;
    }

    public static Boolean getEnableNumberProcessor() {
        return StringUtils.isNotBlank((CharSequence)numberProcessorName.trim());
    }

    @Value(value="${dap.json.number-processor-name:}")
    public void setNumberProcessorName(String numberProcessorName) {
        DWJsonConfig.numberProcessorName = numberProcessorName;
    }

    public static String getNumberProcessorName() {
        return numberProcessorName;
    }

    @Value(value="${dap.json.deserialize-empty-str-to-null:false}")
    public void setDeserializeEmptyStrToNull(Boolean deserializeEmptyStrToNull) {
        DWJsonConfig.deserializeEmptyStrToNull = deserializeEmptyStrToNull;
    }

    public static Boolean getDeserializeEmptyStrToNull() {
        String deserializeEmptyStrToNullSetting = DWApplicationConfigUtils.getProperty((String)"dwJsonEmptyStrToNullEnabled");
        if (StringUtils.isNotEmpty((CharSequence)deserializeEmptyStrToNullSetting)) {
            return Boolean.parseBoolean(deserializeEmptyStrToNullSetting);
        }
        return deserializeEmptyStrToNull;
    }
}

