/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.json.gson;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.json.gson.deserializer.DWBooleanDeserializer;
import com.digiwin.app.json.gson.deserializer.DWDateDeserializer;
import com.digiwin.app.json.gson.deserializer.DWNumberDeserializer;
import com.digiwin.app.service.DWServiceContext;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DWGsonProvider {
    private static Log log = LogFactory.getLog(DWGsonProvider.class);
    public static final String DESERIALIZATION_DATEFORMAT = "dap.json.deserialization.dateformat";
    private static List<Class<?>> typeList = new ArrayList();
    private static List<Object> adapterList = new ArrayList<Object>();
    private static boolean enabledEmptyStrToNull = Boolean.valueOf(DWApplicationConfigUtils.getProperty((String)"dwJsonEmptyStrToNullEnabled", (String)"false"));
    public static boolean serializeNulls = Boolean.valueOf(DWApplicationConfigUtils.getProperty((String)"dwJsonSerializeNulls", (String)"true"));
    private static boolean emptyStrAdpaterLoaded = false;
    private static List<TypeToken> typeTokenList = new ArrayList<TypeToken>();
    private static List<Object> typeTokenAdapterList = new ArrayList<Object>();
    private static String datePattern = DWApplicationConfigUtils.getProperty((String)"dap.json.dateformat", (String)"yyyy/MM/dd HH:mm:ss");

    public static boolean getEnabledEmptyStrToNull() {
        return enabledEmptyStrToNull;
    }

    public static boolean getSerializeNulls() {
        return serializeNulls;
    }

    public static void registerTypeAdapter(Class<?> type, Object adpater) {
        typeList.add(type);
        adapterList.add(adpater);
    }

    public static void registerTypeTokenAdapter(TypeToken typeToken, Object adapter) {
        typeTokenList.add(typeToken);
        typeTokenAdapterList.add(adapter);
    }

    public static boolean hasAdapterInstance(Class<?> adapterClazz) {
        return adapterList.stream().anyMatch(a -> a.getClass().equals(adapterClazz));
    }

    public static void setDateFormat(String pattern) {
        datePattern = pattern;
    }

    public static Gson getGson() {
        int i;
        GsonBuilder builder = new GsonBuilder();
        if (serializeNulls) {
            builder.serializeNulls();
        }
        builder.setDateFormat((String)DWServiceContext.getContext().get(DESERIALIZATION_DATEFORMAT, (Object)datePattern));
        if (enabledEmptyStrToNull && !emptyStrAdpaterLoaded) {
            emptyStrAdpaterLoaded = true;
            DWNumberDeserializer numberAdapter = new DWNumberDeserializer();
            DWGsonProvider.registerTypeAdapter(Integer.TYPE, numberAdapter);
            DWGsonProvider.registerTypeAdapter(Integer.class, numberAdapter);
            DWGsonProvider.registerTypeAdapter(Long.TYPE, numberAdapter);
            DWGsonProvider.registerTypeAdapter(Long.class, numberAdapter);
            DWGsonProvider.registerTypeAdapter(Float.TYPE, numberAdapter);
            DWGsonProvider.registerTypeAdapter(Float.class, numberAdapter);
            DWGsonProvider.registerTypeAdapter(Double.TYPE, numberAdapter);
            DWGsonProvider.registerTypeAdapter(Double.class, numberAdapter);
            DWGsonProvider.registerTypeAdapter(BigDecimal.class, numberAdapter);
            DWBooleanDeserializer booleanAdaptor = new DWBooleanDeserializer();
            DWGsonProvider.registerTypeAdapter(Boolean.TYPE, booleanAdaptor);
            DWGsonProvider.registerTypeAdapter(Boolean.class, booleanAdaptor);
            DWGsonProvider.registerTypeAdapter(Date.class, new DWDateDeserializer(datePattern));
            ReflectiveTypeAdapterFactory.enableEmptyStrToNull();
        }
        if (log.isDebugEnabled()) {
            int i2;
            log.debug((Object)("type list size = " + typeList.size()));
            for (i2 = 0; i2 < typeList.size(); ++i2) {
                log.debug((Object)("type list index=" + i2 + ", class name=" + typeList.get(i2).getCanonicalName()));
            }
            log.debug((Object)("adpater ist size = " + adapterList.size()));
            for (i2 = 0; i2 < adapterList.size(); ++i2) {
                log.debug((Object)("adapter list index=" + i2 + ", class name=" + adapterList.get(i2).getClass().getCanonicalName()));
            }
            log.debug((Object)("type token list size = " + typeTokenList.size()));
            for (i2 = 0; i2 < typeTokenList.size(); ++i2) {
                log.debug((Object)("type token list index=" + i2 + ", class name=" + typeTokenList.get(i2).getClass().getCanonicalName()));
            }
            log.debug((Object)("type token adpater ist size = " + typeTokenAdapterList.size()));
            for (i2 = 0; i2 < typeTokenAdapterList.size(); ++i2) {
                log.debug((Object)("type token adapter list index=" + i2 + ", class name=" + typeTokenAdapterList.get(i2).getClass().getCanonicalName()));
            }
        }
        for (i = 0; i < typeList.size(); ++i) {
            builder.registerTypeAdapter((Type)typeList.get(i), adapterList.get(i));
        }
        for (i = 0; i < typeTokenList.size(); ++i) {
            builder.registerTypeAdapter(typeTokenList.get(i).getType(), typeTokenAdapterList.get(i));
        }
        Gson gson = builder.create();
        return gson;
    }
}

