/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.json.gson.adapter;

import com.digiwin.app.json.DWJsonConfig;
import com.digiwin.app.json.processor.number.DWNumberProcessor;
import com.digiwin.app.service.DWServiceContext;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public class DWObjectTypeAdapter
extends TypeAdapter<Object> {
    private DWNumberProcessor numberProcessor;

    public DWObjectTypeAdapter(DWNumberProcessor numberProcessor) {
        this.numberProcessor = numberProcessor;
    }

    public void write(JsonWriter out, Object value) throws IOException {
        GsonBuilder builder = new GsonBuilder();
        String dateFormatPattern = (String)DWServiceContext.getContext().get("dap.json.deserialization.dateformat", (Object)DWJsonConfig.getDateTimeFormat());
        builder.setDateFormat(dateFormatPattern);
        builder.create().getAdapter(Object.class).write(out, value);
    }

    public Object read(JsonReader in) throws IOException {
        JsonToken token = in.peek();
        switch (token) {
            case BEGIN_ARRAY: {
                ArrayList<Object> list = new ArrayList<Object>();
                in.beginArray();
                while (in.hasNext()) {
                    list.add(this.read(in));
                }
                in.endArray();
                return list;
            }
            case BEGIN_OBJECT: {
                LinkedTreeMap map = new LinkedTreeMap();
                in.beginObject();
                while (in.hasNext()) {
                    map.put(in.nextName(), this.read(in));
                }
                in.endObject();
                return map;
            }
            case STRING: {
                return in.nextString();
            }
            case NUMBER: {
                String val = in.nextString();
                return this.numberProcessor.process(val);
            }
            case BOOLEAN: {
                return in.nextBoolean();
            }
            case NULL: {
                in.nextNull();
                return null;
            }
        }
        throw new IllegalStateException();
    }
}

