/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.json.gson;

import com.digiwin.app.json.DWJsonConfig;
import com.digiwin.app.json.gson.adapter.DWObjectTypeAdapter;
import com.digiwin.app.json.gson.deserializer.DWBooleanDeserializer;
import com.digiwin.app.json.gson.deserializer.DWDateDeserializer;
import com.digiwin.app.json.gson.deserializer.DWNumberDeserializer;
import com.digiwin.app.json.gson.serializer.DWLocalDateTimeSerializer;
import com.digiwin.app.json.processor.number.DWNumberProcessor;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.service.DWServiceContext;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DWGsonProvider {
    private static final Log log = LogFactory.getLog(DWGsonProvider.class);
    public static final String DESERIALIZATION_DATEFORMAT = "dap.json.deserialization.dateformat";
    private static String datePattern = DWJsonConfig.getDateTimeFormat();
    public static boolean serializeNulls = DWJsonConfig.getSerializeNull();
    private static boolean enabledEmptyStrToNull = DWJsonConfig.getDeserializeEmptyStrToNull();
    private static boolean emptyStrAdapterLoaded = false;
    private static boolean numberConvertAdapterLoaded = false;
    private static List<Class<?>> typeList = new ArrayList();
    private static List<Object> adapterList = new ArrayList<Object>();
    private static List<TypeToken> typeTokenList = new ArrayList<TypeToken>();
    private static List<Object> typeTokenAdapterList = new ArrayList<Object>();

    public static List<Class<?>> getTypeList() {
        return typeList;
    }

    public static List<Object> getAdapterList() {
        return adapterList;
    }

    public static List<TypeToken> getTypeTokenList() {
        return typeTokenList;
    }

    public static List<Object> getTypeTokenAdapterList() {
        return typeTokenAdapterList;
    }

    public static boolean getSerializeNulls() {
        return serializeNulls;
    }

    public static boolean getEnabledEmptyStrToNull() {
        return enabledEmptyStrToNull;
    }

    public static void registerTypeAdapter(Class<?> type, Object adapter) {
        typeList.add(type);
        adapterList.add(adapter);
    }

    public static void registerTypeTokenAdapter(TypeToken typeToken, Object adapter) {
        typeTokenList.add(typeToken);
        typeTokenAdapterList.add(adapter);
    }

    public static boolean hasAdapterInstance(Class<?> adapterClazz) {
        return adapterList.stream().anyMatch(a -> a.getClass().equals(adapterClazz));
    }

    public static void setDateFormat(String pattern) {
        datePattern = pattern;
    }

    public static Gson getGson() {
        int i;
        GsonBuilder builder = new GsonBuilder();
        if (serializeNulls) {
            builder.serializeNulls();
        }
        builder.disableHtmlEscaping();
        DWGsonProvider.setDateFormat(builder);
        DWGsonProvider.registerNumberConvertAdapter();
        DWGsonProvider.registerEmptyStrAdapter();
        DWGsonProvider.logAdapterInfo();
        for (i = 0; i < typeList.size(); ++i) {
            builder.registerTypeAdapter((Type)typeList.get(i), adapterList.get(i));
        }
        for (i = 0; i < typeTokenList.size(); ++i) {
            builder.registerTypeAdapter(typeTokenList.get(i).getType(), typeTokenAdapterList.get(i));
        }
        return builder.create();
    }

    private static void setDateFormat(GsonBuilder builder) {
        String dateFormatPattern = (String)DWServiceContext.getContext().get(DESERIALIZATION_DATEFORMAT, (Object)datePattern);
        builder.setDateFormat(dateFormatPattern);
        builder.registerTypeAdapter(LocalDateTime.class, (Object)new DWLocalDateTimeSerializer(dateFormatPattern));
    }

    private static void registerNumberConvertAdapter() {
        if (DWJsonConfig.getEnableNumberProcessor().booleanValue() && !numberConvertAdapterLoaded) {
            numberConvertAdapterLoaded = true;
            DWNumberProcessor numberProcessor = (DWNumberProcessor)SpringContextUtils.getBean((String)"dw-json-number-processor");
            DWGsonProvider.batchRegister((Object)new DWObjectTypeAdapter(numberProcessor));
        }
    }

    private static void batchRegister(Object adapter) {
        ArrayList<TypeToken> list = new ArrayList<TypeToken>();
        list.add(new TypeToken<List>(){});
        list.add(new TypeToken<List<Object>>(){});
        list.add(new TypeToken<ArrayList>(){});
        list.add(new TypeToken<ArrayList<Object>>(){});
        list.add(new TypeToken<Map<String, Object>>(){});
        list.add(new TypeToken<HashMap<String, Object>>(){});
        list.add(new TypeToken<LinkedHashMap<String, Object>>(){});
        list.stream().forEach(typeToken -> DWGsonProvider.registerTypeTokenAdapter(typeToken, adapter));
    }

    private static void registerEmptyStrAdapter() {
        if (enabledEmptyStrToNull && !emptyStrAdapterLoaded) {
            emptyStrAdapterLoaded = true;
            DWNumberDeserializer numberAdapter = new DWNumberDeserializer();
            DWGsonProvider.registerTypeAdapter(Integer.TYPE, numberAdapter);
            DWGsonProvider.registerTypeAdapter(Integer.class, numberAdapter);
            DWGsonProvider.registerTypeAdapter(Long.TYPE, numberAdapter);
            DWGsonProvider.registerTypeAdapter(Long.class, numberAdapter);
            DWGsonProvider.registerTypeAdapter(Float.TYPE, numberAdapter);
            DWGsonProvider.registerTypeAdapter(Float.class, numberAdapter);
            DWGsonProvider.registerTypeAdapter(Double.TYPE, numberAdapter);
            DWGsonProvider.registerTypeAdapter(Double.class, numberAdapter);
            DWGsonProvider.registerTypeAdapter(BigDecimal.class, numberAdapter);
            DWBooleanDeserializer booleanAdaptor = new DWBooleanDeserializer();
            DWGsonProvider.registerTypeAdapter(Boolean.TYPE, booleanAdaptor);
            DWGsonProvider.registerTypeAdapter(Boolean.class, booleanAdaptor);
            DWGsonProvider.registerTypeAdapter(Date.class, new DWDateDeserializer(datePattern));
            ReflectiveTypeAdapterFactory.enableEmptyStrToNull();
        }
    }

    private static void logAdapterInfo() {
        if (log.isDebugEnabled()) {
            int typeListSize = typeList.size();
            log.debug((Object)("type list size = " + typeListSize));
            for (int i = 0; i < typeListSize; ++i) {
                log.debug((Object)("type list index=" + i + ", class name=" + typeList.get(i).getCanonicalName()));
            }
            int adapterListSize = adapterList.size();
            log.debug((Object)("adapter list size = " + adapterListSize));
            for (int i = 0; i < adapterListSize; ++i) {
                log.debug((Object)("adapter list index=" + i + ", class name=" + adapterList.get(i).getClass().getCanonicalName()));
            }
            int typeTokenListSize = typeTokenList.size();
            log.debug((Object)("type token list size = " + typeTokenListSize));
            for (int i = 0; i < typeTokenListSize; ++i) {
                log.debug((Object)("type token list index=" + i + ", class name=" + typeTokenList.get(i).getType().getTypeName()));
            }
            int typeTokenAdapterListSize = typeTokenAdapterList.size();
            log.debug((Object)("type token adapter list size = " + typeTokenAdapterListSize));
            for (int i = 0; i < typeTokenAdapterListSize; ++i) {
                log.debug((Object)("type token adapter list index=" + i + ", class name=" + typeTokenAdapterList.get(i).getClass().getCanonicalName()));
            }
        }
    }
}

