/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common.launcher;

import io.xjar.XConstants;
import io.xjar.XDecryptor;
import io.xjar.XEncryptor;
import io.xjar.XJdkDecryptor;
import io.xjar.XJdkEncryptor;
import io.xjar.XKit;
import io.xjar.key.XKey;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

public class DWXLauncher
implements XConstants {
    public final String[] args;
    public final XDecryptor xDecryptor;
    public final XEncryptor xEncryptor;
    public final XKey xKey;
    String XCLASS_PASSWORD = "--xclass.password=";

    public DWXLauncher(String ... args) throws Exception {
        this.args = args;
        String algorithm = "AES";
        int keysize = 128;
        int ivsize = 128;
        String password = null;
        for (String arg : args) {
            if (arg.toLowerCase().startsWith("--xjar.algorithm=")) {
                algorithm = arg.substring("--xjar.algorithm=".length());
            }
            if (arg.toLowerCase().startsWith("--xjar.keysize=")) {
                keysize = Integer.valueOf(arg.substring("--xjar.keysize=".length()));
            }
            if (arg.toLowerCase().startsWith("--xjar.ivsize=")) {
                ivsize = Integer.valueOf(arg.substring("--xjar.ivsize=".length()));
            }
            if (!arg.toLowerCase().startsWith(this.XCLASS_PASSWORD)) continue;
            password = arg.substring(this.XCLASS_PASSWORD.length());
        }
        this.xDecryptor = new XJdkDecryptor(algorithm);
        this.xEncryptor = new XJdkEncryptor(algorithm);
        this.xKey = XKit.key((String)algorithm, (int)keysize, (int)ivsize, password);
    }

    public static DWXLauncher generateDWXLauncherFromSystemProperties() throws Exception {
        Properties prop = System.getProperties();
        ArrayList<String> args = new ArrayList<String>();
        for (Map.Entry<Object, Object> entry : prop.entrySet()) {
            args.add(entry.getKey() + "=" + entry.getValue());
        }
        DWXLauncher launcher = new DWXLauncher(args.toArray(new String[args.size()]));
        return launcher;
    }
}

