/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common;

import com.digiwin.app.common.launcher.DWXClassLauncher;
import com.digiwin.app.common.launcher.DWXLauncher;
import io.xjar.XDecryptor;
import io.xjar.XEncryptor;
import io.xjar.XKit;
import io.xjar.jar.XJarURLHandler;
import io.xjar.key.XKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandler;
import java.util.Enumeration;

public class DWXClassLoader
extends URLClassLoader {
    private XJarURLHandler xJarURLHandler = null;
    private XDecryptor xDecryptor;
    private XEncryptor xEncryptor;
    private XKey xKey;

    public DWXClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        if (System.getProperties().containsKey(DWXClassLauncher.XCLASS_LAUNCHER_KEY)) {
            try {
                DWXLauncher dwxlauncher = DWXLauncher.generateDWXLauncherFromSystemProperties();
                this.xDecryptor = dwxlauncher.xDecryptor;
                this.xEncryptor = dwxlauncher.xEncryptor;
                this.xKey = dwxlauncher.xKey;
                this.xJarURLHandler = new XJarURLHandler(this.xDecryptor, this.xEncryptor, this.xKey, (ClassLoader)this);
            }
            catch (Exception e) {
                System.err.println("DWXClassLoader(URL[] urls, ClassLoader parent) constructor exception! Exception=" + e.getMessage());
            }
        }
    }

    public DWXClassLoader(URL[] urls, ClassLoader parent, XDecryptor xDecryptor, XEncryptor xEncryptor, XKey xKey) {
        super(urls, parent);
        this.xDecryptor = xDecryptor;
        this.xEncryptor = xEncryptor;
        this.xKey = xKey;
        try {
            this.xJarURLHandler = new XJarURLHandler(xDecryptor, xEncryptor, xKey, (ClassLoader)this);
        }
        catch (Exception e) {
            System.err.println("DWXClassLoader(URL[] urls, ClassLoader parent, XDecryptor xDecryptor, XEncryptor xEncryptor, XKey xKey) constructor exception! Exception=" + e.getMessage());
        }
    }

    @Override
    public URL findResource(String name) {
        URL url = super.findResource(name);
        if (url == null) {
            return null;
        }
        try {
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile(), (URLStreamHandler)this.xJarURLHandler);
        }
        catch (MalformedURLException e) {
            return url;
        }
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> enumeration = super.findResources(name);
        if (enumeration == null) {
            return null;
        }
        return new XJarEnumeration(enumeration);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassFormatError e) {
            URL resource = this.findResource(name.replace('.', '/') + ".class");
            if (resource == null) {
                throw new ClassNotFoundException(name, e);
            }
            try (InputStream in = resource.openStream();){
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                XKit.transfer((InputStream)in, (OutputStream)bos);
                byte[] bytes = bos.toByteArray();
                Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
                return clazz;
            }
            catch (Throwable t) {
                throw new ClassNotFoundException(name, t);
            }
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    private class XJarEnumeration
    implements Enumeration<URL> {
        private final Enumeration<URL> enumeration;

        XJarEnumeration(Enumeration<URL> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasMoreElements() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public URL nextElement() {
            URL url = this.enumeration.nextElement();
            if (url == null) {
                return null;
            }
            try {
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile(), (URLStreamHandler)DWXClassLoader.this.xJarURLHandler);
            }
            catch (MalformedURLException e) {
                return url;
            }
        }
    }
}

