/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common.launcher;

import com.digiwin.app.common.DWXClassLoader;
import com.digiwin.app.common.launcher.DWXLauncher;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;

public class DWXClassLauncher {
    private final DWXLauncher xLauncher;
    String XCLASS_MAINCLASS = "--xclass.mainclass=";
    public static String XCLASS_LAUNCHER_KEY = "--xclass.launcher";
    String XCLASS_LAUNCHER = XCLASS_LAUNCHER_KEY + "=true";

    public DWXClassLauncher(String ... args) throws Exception {
        this.xLauncher = new DWXLauncher(args);
    }

    public static void main(String ... args) throws Exception {
        DWXClassLauncher launcher = new DWXClassLauncher(args);
        launcher.launch(args);
    }

    public void launch(String ... args) throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        DWXClassLoader launcherClassLoader = null;
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            launcherClassLoader = new DWXClassLoader(urlClassLoader.getURLs(), classLoader.getParent(), this.xLauncher.xDecryptor, this.xLauncher.xEncryptor, this.xLauncher.xKey);
        } else {
            String path;
            ProtectionDomain domain = this.getClass().getProtectionDomain();
            String[] source = domain.getCodeSource();
            URI location = source == null ? null : source.getLocation().toURI();
            String string = path = location == null ? null : location.getSchemeSpecificPart();
            if (path == null) {
                throw new IllegalStateException("Unable to determine code source archive");
            }
            File jar = new File(path);
            URL url = jar.toURI().toURL();
            launcherClassLoader = new DWXClassLoader(new URL[]{url}, classLoader.getParent(), this.xLauncher.xDecryptor, this.xLauncher.xEncryptor, this.xLauncher.xKey);
        }
        Thread.currentThread().setContextClassLoader(launcherClassLoader);
        String mainClassName = null;
        for (String arg : this.xLauncher.args) {
            int firstEqualIndex;
            if (arg.toLowerCase().startsWith(this.XCLASS_MAINCLASS)) {
                mainClassName = arg.substring(this.XCLASS_MAINCLASS.length());
            }
            if ((firstEqualIndex = arg.indexOf("=")) == -1) continue;
            String prefix = arg.substring(0, firstEqualIndex);
            String postfix = arg.substring(firstEqualIndex + 1, arg.length());
            System.setProperty(prefix, postfix);
        }
        this.setArgToSystemProperty(this.XCLASS_LAUNCHER);
        if (mainClassName == null) {
            throw new Exception(this.XCLASS_MAINCLASS + " no defined!");
        }
        Class<?> mainClass = launcherClassLoader.loadClass(mainClassName);
        Method mainMethod = mainClass.getMethod("main", String[].class);
        mainMethod.invoke(null, new Object[]{this.xLauncher.args});
    }

    public void setArgToSystemProperty(String arg) {
        int firstEqualIndex = arg.indexOf("=");
        if (firstEqualIndex != -1) {
            String prefix = arg.substring(0, firstEqualIndex);
            String postfix = arg.substring(firstEqualIndex + 1, arg.length());
            System.setProperty(prefix, postfix);
        }
    }
}

