/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common.launcher;

import com.digiwin.app.common.DWXClassLoader;
import com.digiwin.app.common.launcher.DWXLauncher;
import java.lang.reflect.Method;
import java.net.URLClassLoader;

public class DWXClassLauncher {
    private final DWXLauncher xLauncher;
    public static String XCLASS_MAINCLASS = "--xclass.mainclass=";
    public static String XCLASS_LAUNCHER_KEY = "--xclass.launcher";
    public static String XCLASS_LAUNCHER = XCLASS_LAUNCHER_KEY + "=true";

    public DWXClassLauncher(String ... args) throws Exception {
        this.xLauncher = new DWXLauncher(args);
    }

    public static void main(String ... args) throws Exception {
        DWXClassLauncher launcher = new DWXClassLauncher(args);
        launcher.launch(args);
    }

    public void launch(String ... args) throws Exception {
        String mainClassName = null;
        for (String arg : this.xLauncher.args) {
            if (arg.toLowerCase().startsWith(XCLASS_MAINCLASS)) {
                mainClassName = arg.substring(XCLASS_MAINCLASS.length());
            }
            this.setArgToSystemProperty(arg);
        }
        this.setArgToSystemProperty(XCLASS_LAUNCHER);
        if (mainClassName == null) {
            throw new Exception(XCLASS_MAINCLASS + " no defined!");
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        DWXClassLoader launcherClassLoader = null;
        URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
        launcherClassLoader = new DWXClassLoader(urlClassLoader.getURLs(), classLoader.getParent(), this.xLauncher.xDecryptor, this.xLauncher.xEncryptor, this.xLauncher.xKey);
        Thread.currentThread().setContextClassLoader(launcherClassLoader);
        Class<?> mainClass = launcherClassLoader.loadClass(mainClassName);
        Method mainMethod = mainClass.getMethod("main", String[].class);
        mainMethod.invoke(null, new Object[]{this.xLauncher.args});
    }

    public void setArgToSystemProperty(String arg) {
        int firstEqualIndex = arg.indexOf("=");
        if (firstEqualIndex != -1) {
            String prefix = arg.substring(0, firstEqualIndex);
            String postfix = arg.substring(firstEqualIndex + 1, arg.length());
            System.setProperty(prefix, postfix);
        }
    }
}

