/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.common;

import com.digiwin.app.common.DWXJarEnumeration;
import com.digiwin.app.common.DWXJarURLHandler;
import com.digiwin.app.common.launcher.DWXClassLauncher;
import com.digiwin.app.common.launcher.DWXLauncher;
import io.xjar.XDecryptor;
import io.xjar.XEncryptor;
import io.xjar.XKit;
import io.xjar.key.XKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandler;
import java.util.Enumeration;

public class DWXClassLoader
extends URLClassLoader {
    private DWXJarURLHandler handler = null;
    private XDecryptor xDecryptor;
    private XEncryptor xEncryptor;
    private XKey xKey;
    private Exception constructorException;

    public DWXClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        if (System.getProperties().containsKey(DWXClassLauncher.XCLASS_LAUNCHER_KEY)) {
            try {
                DWXLauncher dwxlauncher = DWXLauncher.generateDWXLauncherFromSystemProperties();
                this.xDecryptor = dwxlauncher.xDecryptor;
                this.xEncryptor = dwxlauncher.xEncryptor;
                this.xKey = dwxlauncher.xKey;
                this.handler = DWXJarURLHandler.getInstance(this.xDecryptor, this.xEncryptor, this.xKey, this);
            }
            catch (Exception e) {
                System.err.println("DWXClassLoader(URL[] urls, ClassLoader parent) constructor exception! Exception=" + e.getMessage());
                this.constructorException = e;
            }
        }
    }

    public DWXClassLoader(URL[] urls, ClassLoader parent, XDecryptor xDecryptor, XEncryptor xEncryptor, XKey xKey) {
        super(urls, parent);
        this.xDecryptor = xDecryptor;
        this.xEncryptor = xEncryptor;
        this.xKey = xKey;
        try {
            this.handler = DWXJarURLHandler.getInstance(xDecryptor, xEncryptor, xKey, this);
        }
        catch (Exception e) {
            System.err.println("DWXClassLoader(URL[] urls, ClassLoader parent, XDecryptor xDecryptor, XEncryptor xEncryptor, XKey xKey) constructor exception! Exception=" + e.getMessage());
            this.constructorException = e;
        }
    }

    @Override
    public URL findResource(String name) {
        URL url = super.findResource(name);
        if (url == null) {
            return null;
        }
        try {
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile(), (URLStreamHandler)((Object)this.handler));
        }
        catch (MalformedURLException e) {
            return url;
        }
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> enumeration = super.findResources(name);
        if (enumeration == null) {
            return null;
        }
        return new DWXJarEnumeration(enumeration, this.handler);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassFormatError e) {
            Class<?> clazz;
            block11: {
                URL resource = this.findResource(name.replace('.', '/') + ".class");
                if (resource == null) {
                    throw new ClassNotFoundException(name, e);
                }
                InputStream in = resource.openStream();
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    XKit.transfer((InputStream)in, (OutputStream)bos);
                    byte[] bytes = bos.toByteArray();
                    clazz = this.defineClass(name, bytes, 0, bytes.length);
                    if (in == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        throw new ClassNotFoundException(name, t);
                    }
                }
                in.close();
            }
            return clazz;
        }
    }

    public Exception getConstructorException() {
        return this.constructorException;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

