/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance.matcher;

import com.digiwin.loadbalance.matcher.DWMatcher;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.core.annotation.Order;
import org.springframework.util.AntPathMatcher;

@Order(value=0x7FFFFFFF)
public class UrlPathMatcher
implements DWMatcher {
    AntPathMatcher antPathMatcher = new AntPathMatcher();

    @Override
    public boolean canApply(HttpUriRequest request) {
        return UrlPathMatcher.isValidUrl(request.getURI().getPath());
    }

    @Override
    public String getCacheKey(HttpUriRequest request) {
        return request.getURI().getPath();
    }

    @Override
    public boolean match(String pattern, HttpUriRequest request) {
        return this.antPathMatcher.match(pattern, request.getURI().getPath());
    }

    public static boolean isValidUrl(String urlString) {
        try {
            new URI(urlString);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }
}

